/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;
import studio.mevera.imperat.BaseThrowableHandler;
import studio.mevera.imperat.FlagRegistrar;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.AttachmentMode;
import studio.mevera.imperat.command.CommandExecution;
import studio.mevera.imperat.command.CommandImpl;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessingChain;
import studio.mevera.imperat.command.suggestions.AutoCompleter;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.command.tree.CommandTree;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.AvailableSince(value="1.0.0")
public interface Command<S extends Source>
extends CommandParameter<S>,
FlagRegistrar<S>,
BaseThrowableHandler<S> {
    public static <S extends Source> Builder<S> create(@NotNull Imperat<S> imperat, String name) {
        return Command.create(imperat, null, name);
    }

    public static <S extends Source> Builder<S> create(@NotNull Imperat<S> imperat, @Nullable Command<S> parent, @NotNull String name) {
        return Command.create(imperat, parent, -1, name);
    }

    public static <S extends Source> Builder<S> create(@NotNull Imperat<S> imperat, @Nullable Command<S> parent, int position, @NotNull String name) {
        return new Builder<S>(imperat, parent, position, name);
    }

    @NotNull
    public Imperat<S> imperat();

    @Override
    public String name();

    public @UnmodifiableView List<String> aliases();

    public void addAliases(List<String> var1);

    default public void addAliases(String ... aliases) {
        this.addAliases(List.of(aliases));
    }

    default public boolean hasName(String name) {
        return this.name().equalsIgnoreCase(name) || this.aliases().contains(name.toLowerCase());
    }

    public CommandTree<S> tree();

    public void visualizeTree();

    @NotNull
    public CommandPathSearch<S> contextMatch(Context<S> var1);

    @Override
    @NotNull
    public Description description();

    @Override
    @NotNull
    default public ParameterType<S, ?> type() {
        return ParameterTypes.command(this.name(), this.aliases());
    }

    @Override
    @ApiStatus.Internal
    default public void position(int position) {
        throw new UnsupportedOperationException("You can't modify the position of a command");
    }

    @Override
    @NotNull
    default public OptionalValueSupplier getDefaultValueSupplier() {
        return OptionalValueSupplier.of(this.name());
    }

    public void addPreProcessor(@NotNull CommandPreProcessor<S> var1);

    public void preProcess(@NotNull Imperat<S> var1, @NotNull Context<S> var2, @NotNull CommandUsage<S> var3) throws ImperatException;

    public void addPostProcessor(@NotNull CommandPostProcessor<S> var1);

    public void postProcess(@NotNull Imperat<S> var1, @NotNull ExecutionContext<S> var2, @NotNull CommandUsage<S> var3) throws ImperatException;

    @NotNull
    @ApiStatus.AvailableSince(value="1.9.0")
    public CommandUsage<S> getEmptyUsage();

    @NotNull
    @ApiStatus.AvailableSince(value="1.9.0")
    public CommandUsage<S> getDefaultUsage();

    @ApiStatus.AvailableSince(value="1.9.0")
    public void setDefaultUsage(@NotNull CommandUsage<S> var1);

    public void addUsage(CommandUsage<S> var1);

    default public void addUsage(CommandUsage.Builder<S> builder, boolean help) {
        this.addUsage(builder.build(this, help));
    }

    default public void addUsage(CommandUsage.Builder<S> builder) {
        this.addUsage(builder, false);
    }

    public Collection<? extends CommandUsage<S>> usages();

    @NotNull
    public CommandUsage<S> getMainUsage();

    public AutoCompleter<S> autoCompleter();

    public void addSubCommand(Command<S> var1, AttachmentMode var2);

    public void addSubCommandUsage(String var1, List<String> var2, CommandUsage.Builder<S> var3, AttachmentMode var4);

    default public void addSubCommandUsage(String subCommand, List<String> aliases, CommandUsage.Builder<S> usage) {
        this.addSubCommandUsage(subCommand, aliases, usage, this.imperat().config().getDefaultAttachmentMode());
    }

    default public void addSubCommandUsage(String subCommand, CommandUsage.Builder<S> usage, AttachmentMode attachmentMode) {
        this.addSubCommandUsage(subCommand, Collections.emptyList(), usage, attachmentMode);
    }

    default public void addSubCommandUsage(String subCommand, CommandUsage.Builder<S> usage) {
        this.addSubCommandUsage(subCommand, usage, this.imperat().config().getDefaultAttachmentMode());
    }

    @Nullable
    public Command<S> getSubCommand(String var1);

    @NotNull
    public Collection<? extends Command<S>> getSubCommands();

    @Nullable
    default public CommandUsage<S> getUsage(Predicate<CommandUsage<S>> usagePredicate) {
        for (CommandUsage<S> usage : this.usages()) {
            if (!usagePredicate.test(usage)) continue;
            return usage;
        }
        return null;
    }

    default public boolean hasParent() {
        return this.parent() != null;
    }

    default public boolean isSubCommand() {
        return this.hasParent();
    }

    @Override
    default public TypeWrap<?> wrappedType() {
        return TypeWrap.of(Command.class);
    }

    @Override
    default public boolean isOptional() {
        return false;
    }

    @Override
    default public boolean isGreedy() {
        return false;
    }

    @Override
    default public boolean isFlag() {
        return false;
    }

    @Override
    default public Command<S> asCommand() {
        return this;
    }

    @Override
    default public String format() {
        return this.name();
    }

    public boolean isIgnoringACPerms();

    public void ignoreACPermissions(boolean var1);

    @ApiStatus.Internal
    @ApiStatus.AvailableSince(value="1.9.0")
    public void registerSubCommand(Command<S> var1);

    @Nullable
    default public String getMainPermission() {
        Iterator<String> iterator = this.getPermissions().iterator();
        if (iterator.hasNext()) {
            String str = iterator.next();
            return str;
        }
        return null;
    }

    public CommandProcessingChain<S, CommandPreProcessor<S>> getPreProcessors();

    public CommandProcessingChain<S, CommandPostProcessor<S>> getPostProcessors();

    public void setPreProcessingChain(CommandProcessingChain<S, CommandPreProcessor<S>> var1);

    public void setPostProcessingChain(CommandProcessingChain<S, CommandPostProcessor<S>> var1);

    public static class Builder<S extends Source> {
        private final Imperat<S> imperat;
        private final Command<S> cmd;

        Builder(@NotNull Imperat<S> imperat, @Nullable Command<S> parent, int position, String name) {
            this.imperat = imperat;
            this.cmd = new CommandImpl<S>(imperat, parent, position, name);
        }

        public Builder<S> ignoreACPermissions(boolean ignore) {
            this.cmd.ignoreACPermissions(ignore);
            return this;
        }

        public Builder<S> aliases(String ... aliases) {
            this.cmd.addAliases(aliases);
            return this;
        }

        public Builder<S> aliases(List<String> aliases) {
            this.cmd.addAliases(aliases);
            return this;
        }

        public Builder<S> description(String description) {
            this.cmd.describe(description);
            return this;
        }

        public Builder<S> description(Description description) {
            return this.description(description.toString());
        }

        public Builder<S> permission(String permission) {
            this.cmd.addPermission(permission);
            return this;
        }

        public Builder<S> defaultExecution(CommandExecution<S> defaultExec) {
            return this.usage(CommandUsage.builder().execute(defaultExec));
        }

        public Builder<S> usage(CommandUsage.Builder<S> usage) {
            this.cmd.addUsage(usage);
            return this;
        }

        public Builder<S> subCommand(Command<S> subCommand, AttachmentMode attachmentMode) {
            this.cmd.addSubCommand(subCommand, attachmentMode);
            return this;
        }

        public Builder<S> subCommand(Command<S> subCommand) {
            return this.subCommand(subCommand, AttachmentMode.DEFAULT);
        }

        public Builder<S> subCommand(String name, CommandUsage.Builder<S> mainUsage, AttachmentMode attachmentMode) {
            return this.subCommand(Command.create(this.imperat, name).usage(mainUsage).build(), attachmentMode);
        }

        public Builder<S> subCommand(String name, CommandUsage.Builder<S> mainUsage) {
            return this.subCommand(name, mainUsage, this.cmd.imperat().config().getDefaultAttachmentMode());
        }

        public Builder<S> preProcessor(CommandPreProcessor<S> preProcessor) {
            this.cmd.addPreProcessor(preProcessor);
            return this;
        }

        public Builder<S> postProcessor(CommandPostProcessor<S> postProcessor) {
            this.cmd.addPostProcessor(postProcessor);
            return this;
        }

        public Builder<S> parent(@Nullable Command<S> parentCmd) {
            this.cmd.parent(parentCmd);
            return this;
        }

        public Builder<S> setMetaPropertiesFromOtherCommand(Command<S> other) {
            this.cmd.setSinglePermission(other.getSinglePermission());
            this.cmd.setDefaultUsage(other.getDefaultUsage());
            for (FlagData flag : other.getRegisteredFlags()) {
                this.cmd.registerFlag(flag);
            }
            this.cmd.setPreProcessingChain(other.getPreProcessors());
            this.cmd.setPostProcessingChain(other.getPostProcessors());
            this.cmd.describe(other.description());
            this.cmd.ignoreACPermissions(other.isIgnoringACPerms());
            return this;
        }

        public Command<S> build() {
            return this.cmd;
        }
    }
}

