/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.CommandExecution;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;

public interface CommandCoordinator<S extends Source> {
    public static <S extends Source> CommandCoordinator<S> sync() {
        return (api, source, context, execution) -> execution.execute(source, context);
    }

    public static <S extends Source> CommandCoordinator<S> async(@Nullable ExecutorService service) {
        return (api, source, context, execution) -> {
            ExecutorService executorService = service;
            if (executorService == null) {
                executorService = ForkJoinPool.commonPool();
            }
            CompletableFuture.runAsync(() -> execution.execute(source, context), executorService);
        };
    }

    public static <S extends Source> CommandCoordinator<S> async() {
        return CommandCoordinator.async(null);
    }

    public void coordinate(@NotNull Imperat<S> var1, @NotNull S var2, @NotNull ExecutionContext<S> var3, @NotNull CommandExecution<S> var4) throws ImperatException;

    @FunctionalInterface
    public static interface UnsafeRunnable
    extends Runnable {
        public void runUnsafe() throws Throwable;

        @Override
        default public void run() {
            try {
                this.runUnsafe();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }
}

