/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.annotations.UnmodifiableView;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.AttachmentMode;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.CommandUsageSet;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessingChain;
import studio.mevera.imperat.command.suggestions.AutoCompleter;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.command.tree.CommandTree;
import studio.mevera.imperat.command.tree.CommandTreeVisualizer;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.ProcessorException;
import studio.mevera.imperat.exception.ThrowableResolver;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.ImperatDebugger;

@ApiStatus.Internal
final class CommandImpl<S extends Source>
implements Command<S> {
    static final int INITIAL_PERMISSIONS_CAPACITY = 3;
    private final String name;
    private final int position;
    private final List<String> aliases = new ArrayList<String>();
    private final Map<String, Command<S>> children = new LinkedHashMap<String, Command<S>>();
    private final CommandUsageSet<S> usages = new CommandUsageSet();
    private final AutoCompleter<S> autoCompleter;
    @Nullable
    private final CommandTree<S> tree;
    @NotNull
    private final CommandTreeVisualizer<S> visualizer;
    @Nullable
    private String permission;
    private Description description = Description.EMPTY;
    private boolean suppressACPermissionChecks = false;
    private CommandUsage<S> mainUsage = null;
    private CommandUsage<S> defaultUsage;
    private final Map<Class<? extends Throwable>, ThrowableResolver<?, S>> errorHandlers = new HashMap();
    @NotNull
    private CommandProcessingChain<S, CommandPreProcessor<S>> preProcessors = CommandProcessingChain.preProcessors().build();
    @NotNull
    private CommandProcessingChain<S, CommandPostProcessor<S>> postProcessors = CommandProcessingChain.postProcessors().build();
    @Nullable
    private Command<S> parent;
    private final CommandUsage<S> emptyUsage;
    @NotNull
    private final SuggestionResolver<S> suggestionResolver;
    @NotNull
    private final Set<FlagData<S>> freeFlags = new HashSet<FlagData<S>>();
    private final Imperat<S> imperat;

    CommandImpl(Imperat<S> imperat, String name) {
        this(imperat, null, name);
    }

    CommandImpl(Imperat<S> imperat, @Nullable Command<S> parent, String name) {
        this(imperat, parent, -1, name);
    }

    CommandImpl(Imperat<S> imperat, @Nullable Command<S> parent, int position, String name) {
        this.imperat = imperat;
        this.parent = parent;
        this.position = position;
        this.name = name.toLowerCase();
        this.emptyUsage = CommandUsage.builder().build(this);
        this.defaultUsage = imperat.config().getGlobalDefaultUsage().build(this);
        this.autoCompleter = AutoCompleter.createNative(this);
        this.tree = parent != null ? null : CommandTree.create(imperat.config(), this);
        this.visualizer = CommandTreeVisualizer.of(this.tree);
        this.suggestionResolver = SuggestionResolver.forCommand(this);
    }

    @Override
    @NotNull
    public Imperat<S> imperat() {
        return this.imperat;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public @Unmodifiable Set<String> getPermissions() {
        if (this.permission == null) {
            return Collections.emptySet();
        }
        return Set.of(this.permission);
    }

    @Override
    public void addPermission(@Nullable String permission) {
        this.permission = permission;
    }

    @Override
    @NotNull
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void position(int position) {
        throw new UnsupportedOperationException("You can't modify the position of a command");
    }

    @Override
    @Nullable
    public String getSinglePermission() {
        return this.permission;
    }

    @Override
    @NotNull
    public CommandPathSearch<S> contextMatch(Context<S> context) {
        if (this.tree != null) {
            ArgumentInput copy = context.arguments().copy();
            copy.removeIf(String::isBlank);
            return this.tree.contextMatch(context, copy);
        }
        throw new IllegalCallerException("Cannot match a sub command in a root's execution !");
    }

    @Override
    public void visualizeTree() {
        ImperatDebugger.debug("Visualizing %s's tree", this.name);
        this.visualizer.visualizeSimple();
        this.visualizer.visualizeUniqueTreeSimple();
    }

    @Override
    public void addPreProcessor(@NotNull CommandPreProcessor<S> preProcessor) {
        this.preProcessors.add(preProcessor);
    }

    @Override
    public void preProcess(@NotNull Imperat<S> api, @NotNull Context<S> context, @NotNull CommandUsage<S> usage) throws ProcessorException {
        for (CommandPreProcessor processor : this.preProcessors) {
            try {
                processor.process(api, context, usage);
            }
            catch (ImperatException e) {
                throw new ProcessorException(ProcessorException.Type.PRE, this, e, context);
            }
        }
    }

    @Override
    public void addPostProcessor(@NotNull CommandPostProcessor<S> postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    @Override
    public void postProcess(@NotNull Imperat<S> api, @NotNull ExecutionContext<S> context, @NotNull CommandUsage<S> usage) throws ProcessorException {
        for (CommandPostProcessor processor : this.postProcessors) {
            try {
                processor.process(api, context);
            }
            catch (ImperatException e) {
                throw new ProcessorException(ProcessorException.Type.POST, this, e, context);
            }
        }
    }

    @Override
    @NotNull
    public CommandUsage<S> getEmptyUsage() {
        return this.emptyUsage;
    }

    @Override
    public FlagParameter<S> asFlagParameter() {
        throw new UnsupportedOperationException("A command cannot be treated as a flag !");
    }

    @Override
    public boolean isGreedyString() {
        return false;
    }

    @Override
    @NotNull
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    @Override
    public void setFormat(String format) {
        throw new UnsupportedOperationException("You cannot change the format of a command/literal parameter");
    }

    @Override
    public boolean similarTo(CommandParameter<?> parameter) {
        return this.name.equalsIgnoreCase(parameter.name());
    }

    @Override
    public @UnmodifiableView List<String> aliases() {
        return this.aliases;
    }

    @Override
    public CommandTree<S> tree() {
        return this.tree;
    }

    @Override
    public void addAliases(List<String> aliases) {
        for (String alias : aliases) {
            this.aliases.add(alias.toLowerCase());
        }
    }

    @Override
    @NotNull
    public CommandUsage<S> getDefaultUsage() {
        return this.defaultUsage;
    }

    @Override
    public void setDefaultUsage(@NotNull CommandUsage<S> usage) {
        this.defaultUsage = Objects.requireNonNull(usage, "Default usage cannot be null");
    }

    @Override
    public void addUsage(CommandUsage<S> usage) {
        if (this.tree != null) {
            this.tree.parseUsage(usage);
        }
        if (usage.isDefault()) {
            this.defaultUsage = usage;
        }
        this.usages.put(usage);
        if (this.mainUsage == null && !usage.isDefault() && usage.getMaxLength() >= 1 && !usage.hasParamType(Command.class)) {
            this.mainUsage = usage;
        }
    }

    @Override
    public Collection<? extends CommandUsage<S>> usages() {
        return this.usages.asSortedSet();
    }

    @Override
    @NotNull
    public CommandUsage<S> getMainUsage() {
        return Optional.ofNullable(this.mainUsage).orElse(this.defaultUsage);
    }

    @Override
    public AutoCompleter<S> autoCompleter() {
        return this.autoCompleter;
    }

    @Override
    @Nullable
    public Command<S> parent() {
        return this.parent;
    }

    @Override
    public void parent(@NotNull Command<S> parent) {
        this.parent = parent;
    }

    @Override
    public void registerSubCommand(Command<S> command) {
        this.children.put(command.name(), command);
    }

    @Override
    public CommandProcessingChain<S, CommandPreProcessor<S>> getPreProcessors() {
        return this.preProcessors;
    }

    @Override
    public CommandProcessingChain<S, CommandPostProcessor<S>> getPostProcessors() {
        return this.postProcessors;
    }

    @Override
    public void setPreProcessingChain(CommandProcessingChain<S, CommandPreProcessor<S>> chain) {
        this.preProcessors = chain;
    }

    @Override
    public void setPostProcessingChain(CommandProcessingChain<S, CommandPostProcessor<S>> chain) {
        this.postProcessors = chain;
    }

    @Override
    public void addSubCommand(Command<S> command, AttachmentMode attachmentMode) {
        command.parent(this);
        this.registerSubCommand(command);
        CommandUsage<S> prime = switch (attachmentMode) {
            case AttachmentMode.EMPTY -> this.getEmptyUsage();
            case AttachmentMode.MAIN, AttachmentMode.UNSET -> this.getMainUsage();
            case AttachmentMode.DEFAULT -> this.getDefaultUsage();
            default -> throw new IllegalArgumentException("Unknown attachment mode: " + String.valueOf((Object)attachmentMode));
        };
        CommandUsage<S> combo = prime.mergeWithCommand(command, command.getMainUsage());
        this.addUsage(combo);
        for (CommandUsage<S> subUsage : command.usages()) {
            if (subUsage.equals(command.getMainUsage())) continue;
            combo = prime.mergeWithCommand(command, subUsage);
            this.addUsage(combo);
        }
    }

    @Override
    public void addSubCommandUsage(String subCommand, List<String> aliases, CommandUsage.Builder<S> usage, AttachmentMode attachmentMode) {
        int position;
        if (attachmentMode == AttachmentMode.EMPTY) {
            position = this.position() + 1;
        } else {
            CommandUsage<S> main = attachmentMode == AttachmentMode.MAIN ? this.getMainUsage() : this.getDefaultUsage();
            position = this.position() + (main.getMinLength() == 0 ? 1 : main.getMinLength());
        }
        Command<S> subCmd = Command.create(this.imperat, this, position, subCommand.toLowerCase()).aliases(aliases).usage(usage).build();
        this.addSubCommand(subCmd, attachmentMode);
    }

    @Override
    @Nullable
    public Command<S> getSubCommand(String name) {
        Command<S> sub = this.children.get(name);
        if (sub != null) {
            return sub;
        }
        for (String subsNames : this.children.keySet()) {
            Command<S> other = this.children.get(subsNames);
            if (other.hasName(name)) {
                return other;
            }
            if (!subsNames.startsWith(name)) continue;
            return other;
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<? extends Command<S>> getSubCommands() {
        return this.children.values();
    }

    @Override
    public boolean isIgnoringACPerms() {
        return this.suppressACPermissionChecks;
    }

    @Override
    public void ignoreACPermissions(boolean suppress) {
        this.suppressACPermissionChecks = suppress;
    }

    @Override
    public void registerFlag(FlagData<S> flag) {
        this.freeFlags.add(flag);
    }

    @Override
    public Optional<FlagData<S>> getFlagFromRaw(String raw) {
        return this.freeFlags.stream().filter(data -> data.acceptsInput(raw)).findFirst();
    }

    @Override
    public Set<FlagData<S>> getRegisteredFlags() {
        return this.freeFlags;
    }

    @Override
    public <T extends Throwable> void setThrowableResolver(Class<T> exception, ThrowableResolver<T, S> resolver) {
        this.errorHandlers.put(exception, resolver);
    }

    @Override
    @Nullable
    public <T extends Throwable> ThrowableResolver<T, S> getThrowableResolver(Class<T> exception) {
        for (Class<T> current = exception; current != null && Throwable.class.isAssignableFrom(current); current = current.getSuperclass()) {
            ThrowableResolver<?, S> resolver = this.errorHandlers.get(current);
            if (resolver == null) continue;
            return resolver;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandImpl)) {
            return false;
        }
        CommandImpl command = (CommandImpl)o;
        return Objects.equals(this.name, command.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public CommandParameter<S> copyWithDifferentPosition(int newPosition) {
        CommandImpl<S> copy = new CommandImpl<S>(this.imperat, this.parent, newPosition, this.name);
        copy.permission = this.permission;
        copy.description = this.description;
        copy.suppressACPermissionChecks = this.suppressACPermissionChecks;
        copy.aliases.addAll(this.aliases);
        for (CommandUsage<S> commandUsage : this.usages()) {
            copy.addUsage(commandUsage);
        }
        for (Command command : this.getSubCommands()) {
            copy.registerSubCommand(command);
        }
        copy.freeFlags.addAll(this.freeFlags);
        copy.errorHandlers.putAll(this.errorHandlers);
        for (CommandPreProcessor commandPreProcessor : this.preProcessors) {
            copy.addPreProcessor(commandPreProcessor);
        }
        for (CommandPostProcessor commandPostProcessor : this.postProcessors) {
            copy.addPostProcessor(commandPostProcessor);
        }
        copy.setDefaultUsage(this.defaultUsage);
        return copy;
    }
}

