/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandCoordinator;
import studio.mevera.imperat.command.CommandExecution;
import studio.mevera.imperat.command.CommandUsageImpl;
import studio.mevera.imperat.command.CooldownHolder;
import studio.mevera.imperat.command.DescriptionHolder;
import studio.mevera.imperat.command.PermissionHolder;
import studio.mevera.imperat.command.cooldown.CooldownHandler;
import studio.mevera.imperat.command.cooldown.UsageCooldown;
import studio.mevera.imperat.command.flags.FlagExtractor;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.ParameterBuilder;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.Preconditions;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface CommandUsage<S extends Source>
extends Iterable<CommandParameter<S>>,
PermissionHolder,
DescriptionHolder,
CooldownHolder {
    @NotNull
    public FlagExtractor<S> getFlagExtractor();

    public boolean hasFlag(String var1);

    @Nullable
    public FlagData<S> getFlagParameterFromRaw(String var1);

    default public void addFlag(CommandParameter<S> flagParam) {
        this.addFlag(flagParam.asFlagParameter().flagData());
    }

    public void addFlag(FlagData<S> var1);

    public Set<FlagData<S>> getUsedFreeFlags();

    public void addParameters(CommandParameter<S> ... var1);

    public void addParameters(List<CommandParameter<S>> var1);

    public List<CommandParameter<S>> getParameters();

    public List<CommandParameter<S>> getParametersWithoutFlags();

    public List<String> getExamples();

    public void addExample(String var1);

    default public void addExamples(List<String> examples) {
        examples.forEach(this::addExample);
    }

    @Nullable
    public CommandParameter<S> getParameter(int var1);

    @NotNull
    public CommandExecution<S> getExecution();

    default public CommandUsage<S> mergeWithCommand(Command<S> subCommand, CommandUsage<S> usage) {
        ArrayList<CommandParameter<S>> comboParams = new ArrayList<CommandParameter<S>>(this.getParameters());
        comboParams.add(subCommand);
        for (CommandParameter param : usage.getParameters()) {
            if (this.hasParameters((CommandParameter<S> p) -> p.equals(param))) continue;
            comboParams.add(param);
        }
        return CommandUsage.builder().coordinator(usage.getCoordinator()).description(subCommand.description().toString()).cooldown(usage.getCooldown()).parameters(comboParams).execute(usage.getExecution()).build(subCommand, usage.isHelp());
    }

    public boolean hasParamType(Class<?> var1);

    public int getMinLength();

    public int getMaxLength();

    public boolean hasParameters(Predicate<CommandParameter<S>> var1);

    @Nullable
    public CommandParameter<S> getParameter(Predicate<CommandParameter<S>> var1);

    @NotNull
    public CooldownHandler<S> getCooldownHandler();

    public void setCooldownHandler(CooldownHandler<S> var1);

    default public boolean isDefault() {
        return this.getParameters().isEmpty() || this.getParameters().stream().noneMatch(CommandParameter::isRequired);
    }

    public CommandCoordinator<S> getCoordinator();

    public void setCoordinator(CommandCoordinator<S> var1);

    public void execute(Imperat<S> var1, S var2, ExecutionContext<S> var3) throws ImperatException;

    public boolean isHelp();

    public boolean hasParameters(List<CommandParameter<S>> var1);

    default public int size() {
        return this.getParameters().size();
    }

    default public String formatted() {
        return CommandUsage.format((String)null, this);
    }

    public static <S extends Source> String format(@Nullable String label, CommandUsage<S> usage) {
        Preconditions.notNull(usage, "usage");
        StringBuilder builder = new StringBuilder(label == null ? "" : label);
        if (label != null) {
            builder.append(' ');
        }
        int i = 0;
        for (CommandParameter<S> parameter : usage.getParameters()) {
            builder.append(parameter.format());
            if (i != usage.getParameters().size() - 1) {
                builder.append(' ');
            }
            ++i;
        }
        return builder.toString();
    }

    public static <S extends Source> String format(@Nullable Command<S> command, CommandUsage<S> usage) {
        String label = command == null ? null : command.name();
        return CommandUsage.format(label, usage);
    }

    public static <S extends Source> Builder<S> builder() {
        return new Builder();
    }

    public static class Builder<S extends Source> {
        private final List<CommandParameter<S>> parameters = new ArrayList<CommandParameter<S>>();
        private CommandExecution<S> execution = CommandExecution.empty();
        private String description = "N/A";
        private String permission = null;
        private UsageCooldown cooldown = null;
        private CommandCoordinator<S> commandCoordinator = CommandCoordinator.sync();
        private final Set<FlagData<S>> flags = new HashSet<FlagData<S>>();
        private final List<String> examples = new ArrayList<String>(3);

        Builder() {
        }

        public Builder<S> coordinator(CommandCoordinator<S> commandCoordinator) {
            this.commandCoordinator = commandCoordinator;
            return this;
        }

        public Builder<S> examples(String ... examples) {
            this.examples.addAll(Arrays.asList(examples));
            return this;
        }

        public Builder<S> execute(CommandExecution<S> execution) {
            this.execution = execution;
            return this;
        }

        public Builder<S> permission(String permission) {
            this.permission = permission;
            return this;
        }

        public Builder<S> cooldown(long value, TimeUnit unit) {
            return this.cooldown(value, unit, null);
        }

        public Builder<S> cooldown(long value, TimeUnit unit, @Nullable String permission) {
            this.cooldown = new UsageCooldown(value, unit, permission);
            return this;
        }

        public Builder<S> cooldown(@Nullable UsageCooldown cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder<S> description(String description) {
            if (description != null) {
                this.description = description;
            }
            return this;
        }

        @SafeVarargs
        public final Builder<S> parameters(ParameterBuilder<S, ?> ... builders) {
            return this.parameters(Arrays.stream(builders).map(ParameterBuilder::build).toList());
        }

        public final Builder<S> parameterBuilders(List<? extends ParameterBuilder<S, ?>> builders) {
            return this.parameters(builders.stream().map(ParameterBuilder::build).toList());
        }

        @SafeVarargs
        public final Builder<S> parameters(CommandParameter<S> ... params) {
            return this.parameters(List.of(params));
        }

        public Builder<S> parameters(List<CommandParameter<S>> params) {
            for (int i = 0; i < params.size(); ++i) {
                CommandParameter<S> parameter = params.get(i);
                if (!parameter.isCommand()) {
                    parameter.position(i);
                }
                this.parameters.add(parameter);
            }
            return this;
        }

        public Builder<S> registerFlags(Set<FlagData<S>> flags) {
            this.flags.addAll(flags);
            return this;
        }

        public Builder<S> setPropertiesFromCommandMainUsage(Command<S> command) {
            CommandUsage<S> mainUsage = command.getMainUsage();
            this.description = mainUsage.description().toString();
            this.permission = mainUsage.getPermissions().stream().findAny().orElse(null);
            this.execution = mainUsage.getExecution();
            this.cooldown = mainUsage.getCooldown();
            this.commandCoordinator = mainUsage.getCoordinator();
            this.execution = mainUsage.getExecution();
            return this;
        }

        public CommandUsage<S> build(@NotNull Command<S> command, boolean help) {
            CommandUsageImpl impl = new CommandUsageImpl(this.execution, help);
            impl.setCoordinator(this.commandCoordinator);
            impl.addPermission(this.permission);
            impl.describe(this.description);
            impl.setCooldown(this.cooldown);
            impl.addParameters(this.parameters.stream().peek(p -> p.parent(command)).toList());
            this.flags.forEach(impl::addFlag);
            impl.getUsedFreeFlags().forEach(command::registerFlag);
            impl.addExamples(this.examples);
            return impl;
        }

        public CommandUsage<S> build(@NotNull Command<S> command) {
            return this.build(command, false);
        }

        public CommandUsage<S> buildAsHelp(@NotNull Command<S> command) {
            return this.build(command, true);
        }
    }
}

