/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.CommandCoordinator;
import studio.mevera.imperat.command.CommandExecution;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.cooldown.CooldownHandler;
import studio.mevera.imperat.command.cooldown.UsageCooldown;
import studio.mevera.imperat.command.flags.FlagExtractor;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.Patterns;

@ApiStatus.Internal
final class CommandUsageImpl<S extends Source>
implements CommandUsage<S> {
    private static final int EXPECTED_PARAMETERS_CAPACITY = 8;
    private static final int EXPECTED_FREE_FLAGS_CAPACITY = 3;
    private final List<CommandParameter<S>> parameters = new ArrayList<CommandParameter<S>>(8);
    private final List<CommandParameter<S>> parametersWithoutFlags = new ArrayList<CommandParameter<S>>(8);
    @NotNull
    private final CommandExecution<S> execution;
    private final boolean help;
    private final Set<String> permissions = new HashSet<String>(3);
    private Description description = Description.of("N/A");
    @NotNull
    private CooldownHandler<S> cooldownHandler;
    @Nullable
    private UsageCooldown cooldown = null;
    private CommandCoordinator<S> commandCoordinator;
    private final Set<FlagData<S>> freeFlags = new HashSet<FlagData<S>>(3);
    private final FlagExtractor<S> flagExtractor;
    private final List<String> examples = new ArrayList<String>(2);

    CommandUsageImpl(@NotNull CommandExecution<S> execution) {
        this(execution, false);
    }

    CommandUsageImpl(@NotNull CommandExecution<S> execution, boolean help) {
        this.execution = execution;
        this.cooldownHandler = CooldownHandler.createDefault(this);
        this.commandCoordinator = CommandCoordinator.sync();
        this.help = help;
        this.flagExtractor = FlagExtractor.createNative(this);
    }

    @Override
    public @Unmodifiable Set<String> getPermissions() {
        return Collections.unmodifiableSet(this.permissions);
    }

    @Override
    public void addPermission(String permission) {
        this.permissions.add(permission);
    }

    @Override
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    @NotNull
    public FlagExtractor<S> getFlagExtractor() {
        return this.flagExtractor;
    }

    @Override
    public boolean hasFlag(String input) {
        return this.getFlagParameterFromRaw(input) != null;
    }

    @Override
    @Nullable
    public FlagData<S> getFlagParameterFromRaw(String rawInput) {
        String raw = rawInput;
        if (Patterns.isInputFlag(rawInput)) {
            boolean isSingle = Patterns.SINGLE_FLAG.matcher(rawInput).matches();
            boolean isDouble = Patterns.DOUBLE_FLAG.matcher(rawInput).matches();
            int offset = 0;
            if (isSingle) {
                offset = 1;
            } else if (isDouble) {
                offset = 2;
            }
            raw = rawInput.substring(offset);
        }
        for (CommandParameter<S> param : this.parameters) {
            FlagData<S> flag;
            if (!param.isFlag() || !(flag = param.asFlagParameter().flagData()).acceptsInput(raw)) continue;
            return flag;
        }
        return null;
    }

    @Override
    public void addFlag(FlagData<S> flagData) {
        this.freeFlags.add(flagData);
        this.flagExtractor.insertFlag(flagData);
    }

    @Override
    public Set<FlagData<S>> getUsedFreeFlags() {
        return this.freeFlags;
    }

    @Override
    @SafeVarargs
    public final void addParameters(CommandParameter<S> ... params) {
        this.addParameters(Arrays.asList(params));
    }

    @Override
    public void addParameters(List<CommandParameter<S>> params) {
        for (CommandParameter<S> param : params) {
            if (param.isFlag() && param.asFlagParameter().flagData().isFree()) {
                this.freeFlags.add(param.asFlagParameter().flagData());
                continue;
            }
            this.parameters.add(param);
            if (param.isFlag()) {
                this.flagExtractor.insertFlag(param.asFlagParameter().flagData());
                continue;
            }
            this.parametersWithoutFlags.add(param);
        }
    }

    @Override
    public List<CommandParameter<S>> getParameters() {
        return this.parameters;
    }

    @Override
    public List<CommandParameter<S>> getParametersWithoutFlags() {
        return this.parametersWithoutFlags;
    }

    @Override
    public List<String> getExamples() {
        return this.examples;
    }

    @Override
    public void addExample(String example) {
        if (this.examples.contains(example)) {
            return;
        }
        this.examples.add(example);
    }

    @Override
    @Nullable
    public CommandParameter<S> getParameter(int index) {
        if (index < 0 || index >= this.parameters.size()) {
            return null;
        }
        return this.parameters.get(index);
    }

    @Override
    @NotNull
    public CommandExecution<S> getExecution() {
        return this.execution;
    }

    @Override
    public boolean hasParamType(Class<?> clazz) {
        return this.getParameters().stream().anyMatch(param -> param.valueType().equals(clazz));
    }

    @Override
    public int getMinLength() {
        return (int)this.getParameters().stream().filter(param -> !param.isFlag()).filter(param -> !param.isOptional()).count();
    }

    @Override
    public int getMaxLength() {
        return this.getParameters().size();
    }

    @Override
    public boolean hasParameters(Predicate<CommandParameter<S>> parameterPredicate) {
        for (CommandParameter<S> parameter : this.getParameters()) {
            if (!parameterPredicate.test(parameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public CommandParameter<S> getParameter(Predicate<CommandParameter<S>> parameterPredicate) {
        for (CommandParameter<S> parameter : this.getParameters()) {
            if (!parameterPredicate.test(parameter)) continue;
            return parameter;
        }
        return null;
    }

    @Override
    @Nullable
    public UsageCooldown getCooldown() {
        return this.cooldown;
    }

    @Override
    public void setCooldown(@Nullable UsageCooldown usageCooldown) {
        this.cooldown = usageCooldown;
    }

    @Override
    @NotNull
    public CooldownHandler<S> getCooldownHandler() {
        return this.cooldownHandler;
    }

    @Override
    public void setCooldownHandler(@NotNull CooldownHandler<S> cooldownHandler) {
        this.cooldownHandler = cooldownHandler;
    }

    @Override
    public CommandCoordinator<S> getCoordinator() {
        return this.commandCoordinator;
    }

    @Override
    public void setCoordinator(CommandCoordinator<S> commandCoordinator) {
        this.commandCoordinator = commandCoordinator;
    }

    @Override
    public void execute(Imperat<S> imperat, S source, ExecutionContext<S> context) throws ImperatException {
        this.commandCoordinator.coordinate(imperat, source, context, this.execution);
    }

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public boolean hasParameters(List<CommandParameter<S>> parameters) {
        if (this.parameters.size() != parameters.size()) {
            return false;
        }
        for (int i = 0; i < parameters.size(); ++i) {
            CommandParameter<S> otherParam;
            CommandParameter<S> thisParam = this.parameters.get(i);
            if (thisParam.similarTo(otherParam = parameters.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Iterator<CommandParameter<S>> iterator() {
        return this.parameters.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandUsageImpl that = (CommandUsageImpl)o;
        if (this.size() != that.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            CommandParameter<S> thisP = this.getParameter(i);
            CommandParameter<S> thatP = that.getParameter(i);
            assert (thisP != null);
            if (thisP.similarTo(thatP)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.parameters);
    }
}

