/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.base.element.ParameterElement;
import studio.mevera.imperat.command.ContextResolverFactory;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.ContextResolver;
import studio.mevera.imperat.util.Registry;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.AvailableSince(value="1.0.0")
public final class ContextResolverRegistry<S extends Source>
extends Registry<Type, ContextResolver<S, ?>> {
    private final Registry<Type, ContextResolverFactory<S, ?>> factories = new Registry();

    private ContextResolverRegistry() {
        this.registerResolver(new TypeWrap<ExecutionContext<S>>(){}.getType(), (ctx, param) -> ctx);
        this.registerResolver(new TypeWrap<ArgumentInput>(){}.getType(), (ctx, param) -> ctx.arguments());
    }

    public static <S extends Source> ContextResolverRegistry<S> createDefault() {
        return new ContextResolverRegistry<S>();
    }

    public <T> void registerResolver(Type type, ContextResolver<S, T> resolver) {
        this.setData(type, resolver);
    }

    public <T> void registerFactory(Type type, ContextResolverFactory<S, T> factory) {
        this.factories.setData(type, factory);
    }

    public Optional<ContextResolverFactory<S, ?>> getFactoryFor(Type type) {
        return this.factories.getData(type);
    }

    @Nullable
    public <T> ContextResolver<S, T> getContextResolver(Type type, @Nullable ParameterElement element) {
        ContextResolverFactory factory = this.getFactoryFor(type).orElse(null);
        if (factory == null) {
            return this.factories.getData(type).map(defaultFactory -> defaultFactory.create(type, element)).orElse(this.getData(type).orElse(null));
        }
        return factory.create(type, element);
    }

    @Nullable
    public <T> ContextResolver<S, T> getResolverWithoutParameterElement(Type type) {
        return this.getContextResolver(type, null);
    }
}

