/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command;

import java.util.Map;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.util.Preconditions;

public interface NumericComparator<N extends Number> {
    public static final NumericComparator<Double> DOUBLE_NUMERIC_COMPARATOR = (number, range) -> range.matches((double)number);
    public static final NumericComparator<Float> FLOAT_NUMERIC_COMPARATOR = (number, range) -> range.matches(number.floatValue());
    public static final NumericComparator<Integer> INTEGER_NUMERIC_COMPARATOR = (number, range) -> range.matches(number.intValue());
    public static final NumericComparator<Long> LONG_NUMERIC_COMPARATOR = (number, range) -> range.matches(number.longValue());
    public static final Map<Class<? extends Number>, NumericComparator<?>> COMPARATORS = Map.of(Double.class, DOUBLE_NUMERIC_COMPARATOR, Float.class, FLOAT_NUMERIC_COMPARATOR, Integer.class, INTEGER_NUMERIC_COMPARATOR, Long.class, LONG_NUMERIC_COMPARATOR);

    public static <N extends Number> NumericComparator<N> of(N value) {
        Preconditions.notNull(value, "Value");
        return COMPARATORS.getOrDefault(value.getClass(), DOUBLE_NUMERIC_COMPARATOR);
    }

    public boolean isWithin(N var1, NumericRange var2);
}

