/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.cooldown;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.cooldown.DefaultCooldownHandler;
import studio.mevera.imperat.command.cooldown.UsageCooldown;
import studio.mevera.imperat.context.Source;

@ApiStatus.AvailableSince(value="1.0.0")
public interface CooldownHandler<S extends Source> {
    public void registerExecutionMoment(S var1);

    public Optional<UsageCooldown> getUsageCooldown();

    default public boolean hasCooldown(S source) {
        UsageCooldown usageCooldown = this.getUsageCooldown().orElse(null);
        if (usageCooldown == null) {
            return false;
        }
        boolean result = this.getLastTimeExecuted(source).map(lastTime -> {
            Duration elapsed = Duration.between(lastTime, Instant.now());
            Duration remaining = usageCooldown.toDuration().minus(elapsed);
            return !remaining.isZero() && !remaining.isNegative();
        }).orElse(false);
        if (!result) {
            this.removeCooldown(source);
        }
        return result;
    }

    public void removeCooldown(S var1);

    public Optional<Instant> getLastTimeExecuted(S var1);

    public static <S extends Source> CooldownHandler<S> createDefault(CommandUsage<S> usage) {
        return new DefaultCooldownHandler<S>(usage);
    }
}

