/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.cooldown;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.cooldown.CooldownHandler;
import studio.mevera.imperat.command.cooldown.UsageCooldown;
import studio.mevera.imperat.context.Source;

final class DefaultCooldownHandler<S extends Source>
implements CooldownHandler<S> {
    private final Map<String, Instant> lastTimeExecuted = new HashMap<String, Instant>();
    private final CommandUsage<S> usage;

    DefaultCooldownHandler(CommandUsage<S> usage) {
        this.usage = usage;
    }

    @Override
    public void registerExecutionMoment(S source) {
        this.lastTimeExecuted.put(source.name(), Instant.now());
    }

    @Override
    public Optional<UsageCooldown> getUsageCooldown() {
        return Optional.ofNullable(this.usage.getCooldown());
    }

    @Override
    public void removeCooldown(S source) {
        this.lastTimeExecuted.remove(source.name());
    }

    @Override
    public Optional<Instant> getLastTimeExecuted(S source) {
        return Optional.ofNullable(this.lastTimeExecuted.get(source.name()));
    }
}

