/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.cooldown;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.AvailableSince(value="1.0.0")
public final class UsageCooldown {
    private final Duration duration;
    private final long value;
    private final TimeUnit unit;
    @Nullable
    private final String permission;

    public UsageCooldown(long value, TimeUnit unit, @Nullable String permission) {
        this.value = value;
        this.unit = unit;
        this.permission = permission;
        this.duration = Duration.of(value, unit.toChronoUnit());
    }

    public Duration toDuration() {
        return this.duration;
    }

    public long value() {
        return this.value;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    @Nullable
    public String permission() {
        return this.permission;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        UsageCooldown that = (UsageCooldown)obj;
        return this.value == that.value && Objects.equals((Object)this.unit, (Object)that.unit) && Objects.equals(this.permission, that.permission);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.unit, this.permission});
    }
}

