/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters;

import java.lang.reflect.Type;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.parameters.AnnotatedParameter;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.DescriptionHolder;
import studio.mevera.imperat.command.PermissionHolder;
import studio.mevera.imperat.command.parameters.FlagBuilder;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.NormalCommandParameter;
import studio.mevera.imperat.command.parameters.NumericParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.ParameterBuilder;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.Preconditions;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.AvailableSince(value="1.0.0")
public interface CommandParameter<S extends Source>
extends PermissionHolder,
DescriptionHolder {
    public static <S extends Source, T> CommandParameter<S> of(String name, ParameterType<S, T> type, @Nullable String permission, Description description, boolean optional, boolean greedy, @NotNull OptionalValueSupplier valueSupplier, @Nullable SuggestionResolver<S> suggestionResolver) {
        Preconditions.notNull(name, "name");
        Preconditions.notNull(type, "type");
        Preconditions.checkArgument(!type.equalsExactly((Type)((Object)Object.class)), "Type cannot be `Object`");
        return new NormalCommandParameter<S>(name, type, permission, description, optional, greedy, valueSupplier, suggestionResolver);
    }

    public static <S extends Source, T> ParameterBuilder<S, T> required(String name, ParameterType<S, T> type) {
        return new ParameterBuilder<S, T>(name, type, false);
    }

    public static <S extends Source> ParameterBuilder<S, Integer> requiredInt(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Integer.class));
    }

    public static <S extends Source> ParameterBuilder<S, Long> requiredLong(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Long.class));
    }

    public static <S extends Source> ParameterBuilder<S, Double> requiredDouble(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Double.class));
    }

    public static <S extends Source> ParameterBuilder<S, Float> requiredFloat(String name) {
        return CommandParameter.required(name, ParameterTypes.numeric(Float.class));
    }

    public static <S extends Source> ParameterBuilder<S, Boolean> requiredBoolean(String name) {
        return CommandParameter.required(name, ParameterTypes.bool());
    }

    public static <S extends Source> ParameterBuilder<S, String> requiredText(String name) {
        return CommandParameter.required(name, ParameterTypes.string());
    }

    public static <S extends Source> ParameterBuilder<S, String> requiredGreedy(String name) {
        return new ParameterBuilder(name, ParameterTypes.string(), false, true);
    }

    public static <S extends Source, T> ParameterBuilder<S, T> optional(String name, ParameterType<S, T> token) {
        return new ParameterBuilder<S, T>(name, token, true);
    }

    public static <S extends Source> ParameterBuilder<S, Integer> optionalInt(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Integer.class));
    }

    public static <S extends Source> ParameterBuilder<S, Long> optionalLong(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Long.class));
    }

    public static <S extends Source> ParameterBuilder<S, Double> optionalDouble(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Double.class));
    }

    public static <S extends Source> ParameterBuilder<S, Float> optionalFloat(String name) {
        return CommandParameter.optional(name, ParameterTypes.numeric(Float.class));
    }

    public static <S extends Source> ParameterBuilder<S, Boolean> optionalBoolean(String name) {
        return CommandParameter.optional(name, ParameterTypes.bool());
    }

    public static <S extends Source> ParameterBuilder<S, String> optionalText(String name) {
        return CommandParameter.optional(name, ParameterTypes.string());
    }

    public static <S extends Source> ParameterBuilder<S, String> optionalGreedy(String name) {
        return new ParameterBuilder(name, ParameterTypes.string(), true, true);
    }

    public static <S extends Source, T> FlagBuilder<S, T> flag(String name, ParameterType<S, T> inputType) {
        return FlagBuilder.ofFlag(name, inputType);
    }

    public static <S extends Source> FlagBuilder<S, Boolean> flagSwitch(String name) {
        return FlagBuilder.ofSwitch(name);
    }

    public static <S extends Source> CommandParameter<S> literal(String part) {
        Preconditions.notNull(part, "part");
        Preconditions.checkArgument(!part.isEmpty(), "Literal part cannot be empty");
        Preconditions.checkArgument(part.chars().allMatch(c -> Character.isLetterOrDigit(c) || c == 95), "Literal part must be alphanumeric or underscore only");
        return CommandParameter.of(part, ParameterTypes.command(part, new ArrayList<String>()), null, Description.EMPTY, false, false, OptionalValueSupplier.empty(), null);
    }

    public String name();

    @Nullable
    public Command<S> parent();

    public void parent(Command<S> var1);

    public int position();

    @ApiStatus.Internal
    public void position(int var1);

    @Nullable
    public String getSinglePermission();

    default public void setSinglePermission(String permission) {
        this.addPermission(this.getSinglePermission());
    }

    public TypeWrap<?> wrappedType();

    default public Type valueType() {
        return this.wrappedType().getType();
    }

    @NotNull
    public ParameterType<S, ?> type();

    @NotNull
    public OptionalValueSupplier getDefaultValueSupplier();

    public boolean isOptional();

    public boolean isFlag();

    public FlagParameter<S> asFlagParameter();

    public boolean isGreedy();

    public boolean isGreedyString();

    default public boolean isCommand() {
        return this instanceof Command;
    }

    public Command<S> asCommand();

    default public boolean isAnnotated() {
        return this instanceof AnnotatedParameter;
    }

    default public AnnotatedParameter<S> asAnnotated() {
        return (AnnotatedParameter)this;
    }

    @Nullable
    public SuggestionResolver<S> getSuggestionResolver();

    public String format();

    public void setFormat(String var1);

    default public boolean isNumeric() {
        return this instanceof NumericParameter;
    }

    default public NumericParameter<S> asNumeric() {
        return (NumericParameter)this;
    }

    public boolean similarTo(CommandParameter<?> var1);

    default public boolean isRequired() {
        return !this.isOptional();
    }

    public CommandParameter<S> copyWithDifferentPosition(int var1);
}

