/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.InputParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.SuggestionResolver;

@ApiStatus.Internal
public final class FlagCommandParameter<S extends Source>
extends InputParameter<S>
implements FlagParameter<S> {
    private final FlagData<S> flag;
    private final OptionalValueSupplier inputValueSupplier;
    private final SuggestionResolver<S> inputValueSuggestionResolver;

    FlagCommandParameter(FlagData<S> flag, String permission, Description description, OptionalValueSupplier inputValueSupplier, SuggestionResolver<S> inputValueSuggestionResolver) {
        super(flag.name(), ParameterTypes.flag(flag), permission, description, true, true, false, OptionalValueSupplier.empty(), null);
        this.flag = flag;
        this.inputValueSupplier = inputValueSupplier;
        this.inputValueSuggestionResolver = inputValueSuggestionResolver;
    }

    @Override
    public String format() {
        if (!this.format.equals(this.name)) {
            return super.format();
        }
        return this.flag.format();
    }

    @Override
    @NotNull
    public FlagData<S> flagData() {
        return this.flag;
    }

    @Override
    @NotNull
    public OptionalValueSupplier getDefaultValueSupplier() {
        return this.inputValueSupplier;
    }

    @Override
    @Nullable
    public SuggestionResolver<S> inputSuggestionResolver() {
        if (this.isSwitch()) {
            return null;
        }
        return this.inputValueSuggestionResolver;
    }

    @Override
    public CommandParameter<S> copyWithDifferentPosition(int newPosition) {
        FlagCommandParameter<S> copy = new FlagCommandParameter<S>(this.flag, this.permission, this.description, this.inputValueSupplier, this.inputValueSuggestionResolver);
        copy.position(newPosition);
        copy.setFormat(this.format);
        return copy;
    }
}

