/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.ParameterArray;
import studio.mevera.imperat.command.parameters.type.ParameterCollection;
import studio.mevera.imperat.command.parameters.type.ParameterCommand;
import studio.mevera.imperat.command.parameters.type.ParameterMap;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.Internal
public abstract class InputParameter<S extends Source>
implements CommandParameter<S> {
    protected Command<S> parentCommand;
    protected final String name;
    protected String format;
    protected final ParameterType<S, ?> type;
    protected final boolean optional;
    protected final boolean flag;
    protected final boolean greedy;
    protected final OptionalValueSupplier optionalValueSupplier;
    protected final SuggestionResolver<S> suggestionResolver;
    protected String permission;
    protected Description description;
    protected int index;

    protected InputParameter(String name, @NotNull ParameterType<S, ?> type, @Nullable String permission, Description description, boolean optional, boolean flag, boolean greedy, @NotNull OptionalValueSupplier optionalValueSupplier, @Nullable SuggestionResolver<S> suggestionResolver) {
        this.name = name;
        this.format = name;
        this.type = type;
        this.permission = permission;
        this.description = description;
        this.optional = optional;
        this.flag = flag;
        this.greedy = greedy;
        this.optionalValueSupplier = optionalValueSupplier;
        this.suggestionResolver = suggestionResolver;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public final void setFormat(String format) {
        this.format = format;
    }

    @Override
    @Nullable
    public Command<S> parent() {
        return this.parentCommand;
    }

    @Override
    public void parent(@NotNull Command<S> parentCommand) {
        this.parentCommand = parentCommand;
    }

    @Override
    public int position() {
        return this.index;
    }

    @Override
    public void position(int position) {
        this.index = position;
    }

    @Override
    @NotNull
    public ParameterType<S, ?> type() {
        return this.type;
    }

    @Override
    public TypeWrap<?> wrappedType() {
        return this.type.wrappedType();
    }

    @Override
    @Nullable
    public String getSinglePermission() {
        return this.permission;
    }

    @Override
    public void setSinglePermission(String permission) {
        CommandParameter.super.setSinglePermission(permission);
    }

    @Override
    public @Unmodifiable Set<String> getPermissions() {
        if (this.permission == null) {
            return Collections.emptySet();
        }
        return Set.of(this.permission);
    }

    @Override
    public void addPermission(String permission) {
        this.permission = permission;
    }

    @Override
    @NotNull
    public OptionalValueSupplier getDefaultValueSupplier() {
        return this.optionalValueSupplier.isEmpty() ? this.type.supplyDefaultValue() : this.optionalValueSupplier;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isFlag() {
        return this.flag || this instanceof FlagParameter;
    }

    @Override
    public FlagParameter<S> asFlagParameter() {
        return (FlagParameter)((Object)this);
    }

    @Override
    public boolean isGreedy() {
        return this.greedy || this.type instanceof ParameterCollection || this.type instanceof ParameterArray || this.type instanceof ParameterMap;
    }

    @Override
    public boolean isGreedyString() {
        boolean isGreedyWrapper = TypeUtility.isAcceptableGreedyWrapper(this.type.type()) && TypeUtility.hasGenericType(this.type.type(), String.class);
        return (this.type.equalsExactly((Type)((Object)String.class)) || isGreedyWrapper) && this.greedy;
    }

    @Override
    public Command<S> asCommand() {
        ParameterType<S, ?> parameterType = this.type;
        if (!(parameterType instanceof ParameterCommand)) {
            throw new UnsupportedOperationException("Non-CommandProcessingChain Parameter cannot be converted into a command parameter");
        }
        ParameterCommand asCommandType = (ParameterCommand)parameterType;
        return this.parentCommand.getSubCommand(asCommandType.getName());
    }

    @Override
    @Nullable
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.suggestionResolver;
    }

    @Override
    public Description description() {
        return this.description;
    }

    @Override
    public void describe(Description description) {
        this.description = description;
    }

    @Override
    public boolean similarTo(CommandParameter<?> parameter) {
        return this.name.equalsIgnoreCase(parameter.name()) && this.type.equalsExactly(parameter.wrappedType().getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InputParameter)) {
            return false;
        }
        InputParameter that = (InputParameter)o;
        return Objects.equals(this.parentCommand, that.parentCommand) && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return this.format();
    }
}

