/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Description;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.InputParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.StringUtils;

class NormalCommandParameter<S extends Source>
extends InputParameter<S> {
    NormalCommandParameter(String name, ParameterType<S, ?> type, @Nullable String permission, Description description, boolean optional, boolean greedy, @NotNull OptionalValueSupplier valueSupplier, @Nullable SuggestionResolver<S> suggestionResolver) {
        super(name, type, permission, description, optional, false, greedy, valueSupplier, suggestionResolver);
    }

    @Override
    public String format() {
        if (!this.format.equals(this.name)) {
            return super.format();
        }
        Object content = this.name();
        if (this.isGreedy()) {
            content = (String)content + "...";
        }
        return StringUtils.normalizedParameterFormatting((String)content, this.isOptional());
    }

    @Override
    public CommandParameter<S> copyWithDifferentPosition(int newPosition) {
        NormalCommandParameter<S> copy = new NormalCommandParameter<S>(this.name, this.type, this.permission, this.description, this.optional, this.greedy, this.optionalValueSupplier, this.suggestionResolver);
        copy.position(newPosition);
        copy.setFormat(this.format);
        return copy;
    }
}

