/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.Preconditions;

public interface OptionalValueSupplier {
    public static final OptionalValueSupplier EMPTY = new OptionalValueSupplier(){

        @Override
        @Nullable
        public <S extends Source> String supply(ExecutionContext<S> context, CommandParameter<S> parameter) {
            return null;
        }
    };

    public static OptionalValueSupplier of(final @NotNull String value) {
        Preconditions.notNull(value, "default cannot be null, use `OptionalValueSupplier#empty` instead");
        return new OptionalValueSupplier(){

            @Override
            @NotNull
            public <S extends Source> String supply(ExecutionContext<S> context, CommandParameter<S> parameter) {
                return value;
            }
        };
    }

    @NotNull
    public static OptionalValueSupplier empty() {
        return EMPTY;
    }

    default public boolean isEmpty() {
        return this == EMPTY;
    }

    @Nullable
    public <S extends Source> String supply(ExecutionContext<S> var1, CommandParameter<S> var2);
}

