/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.TypeWrap;

public abstract class ParameterArray<S extends Source, E>
extends BaseParameterType<S, E[]> {
    private final Function<Integer, Object[]> initializer;
    private final ParameterType<S, E> componentType;

    public ParameterArray(TypeWrap<E[]> type, Function<Integer, Object[]> initializer, ParameterType<S, E> componentType) {
        super(type.getType());
        this.initializer = initializer;
        this.componentType = componentType;
    }

    @Override
    public E @Nullable [] resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> stream, @NotNull String input) throws ImperatException {
        String raw;
        String currentRaw = stream.currentRaw().orElse(null);
        if (currentRaw == null) {
            return null;
        }
        int arrayLength = stream.rawsLength() - stream.currentRawPosition();
        Object[] array = this.initializer.apply(arrayLength);
        int i = 0;
        while (stream.isCurrentRawInputAvailable() && (raw = (String)stream.currentRaw().orElse(null)) != null) {
            array[i] = this.componentType.resolve(context, CommandInputStream.subStream(stream, raw), raw);
            stream.skipRaw();
            ++i;
        }
        return array;
    }

    @Override
    public boolean isGreedy(CommandParameter<S> parameter) {
        return true;
    }
}

