/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.parse.InvalidBooleanException;

public final class ParameterBoolean<S extends Source>
extends BaseParameterType<S, Boolean> {
    private static final Map<String, Boolean> VARIANTS = Map.of("t", true, "f", false, "yes", true, "no", false, "y", true, "n", false, "on", true, "off", false, "enabled", true, "disabled", false);
    private boolean allowVariants = false;

    ParameterBoolean() {
        this.withSuggestions("true", "false");
    }

    @Override
    @Nullable
    public Boolean resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, @NotNull String input) throws ImperatException {
        String raw = commandInputStream.currentRaw().orElse(null);
        assert (raw != null);
        if (raw.equalsIgnoreCase("true") || raw.equalsIgnoreCase("false")) {
            return Boolean.parseBoolean(raw);
        }
        if (this.allowVariants) {
            return VARIANTS.get(raw.toLowerCase());
        }
        throw new InvalidBooleanException(raw, context);
    }

    @Override
    public boolean matchesInput(int rawPosition, Context<S> context, CommandParameter<S> parameter) {
        String currentInput = (String)context.arguments().get(rawPosition);
        if (currentInput == null) {
            return false;
        }
        if (!this.allowVariants && (currentInput.equalsIgnoreCase("true") || currentInput.equalsIgnoreCase("false"))) {
            return true;
        }
        if (this.allowVariants) {
            return VARIANTS.get(currentInput.toLowerCase(Locale.ENGLISH)) != null;
        }
        return Boolean.parseBoolean(currentInput);
    }

    public ParameterBoolean<S> setAllowVariants(boolean allowVariants) {
        this.allowVariants = allowVariants;
        if (allowVariants) {
            this.suggestions.addAll(VARIANTS.keySet());
        } else {
            this.suggestions.removeAll(VARIANTS.keySet());
        }
        return this;
    }

    public ParameterBoolean<S> allowVariants() {
        return this.setAllowVariants(true);
    }
}

