/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.util.Collection;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.TypeWrap;

public class ParameterCollection<S extends Source, E, C extends Collection<E>>
extends BaseParameterType<S, C> {
    private final Supplier<C> collectionSupplier;
    private final ParameterType<S, E> componentResolver;

    public ParameterCollection(TypeWrap<C> type, Supplier<C> collectionSupplier, ParameterType<S, E> componentResolver) {
        super(type.getType());
        this.collectionSupplier = collectionSupplier;
        this.componentResolver = componentResolver;
    }

    @Override
    @Nullable
    public C resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, @NotNull String input) throws ImperatException {
        String raw;
        Collection newCollection = (Collection)this.collectionSupplier.get();
        while (commandInputStream.isCurrentRawInputAvailable() && (raw = (String)commandInputStream.currentRaw().orElse(null)) != null) {
            E element = this.componentResolver.resolve(context, CommandInputStream.subStream(commandInputStream, raw), raw);
            newCollection.add(element);
            commandInputStream.skipRaw();
        }
        return (C)newCollection;
    }

    @Override
    public boolean isGreedy(CommandParameter<S> parameter) {
        return true;
    }
}

