/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.OptionalValueSupplier;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.TypeWrap;

public final class ParameterCompletableFuture<S extends Source, T>
extends BaseParameterType<S, CompletableFuture<T>> {
    private final ParameterType<S, T> typeResolver;

    public ParameterCompletableFuture(TypeWrap<CompletableFuture<T>> typeWrap, ParameterType<S, T> typeResolver) {
        super(typeWrap.getType());
        this.typeResolver = typeResolver;
    }

    @Override
    public @NotNull CompletableFuture<@Nullable T> resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> inputStream, @NotNull String input) throws ImperatException {
        if (this.typeResolver == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("No type parameter for type '" + this.type.getTypeName() + "'"));
        }
        CommandInputStream<S> copyStream = inputStream.copy();
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.typeResolver.resolve(context, copyStream, input);
            }
            catch (ImperatException e) {
                context.imperatConfig().handleExecutionThrowable(e, context, ParameterCompletableFuture.class, "resolve");
                return null;
            }
        });
    }

    @Override
    public SuggestionResolver<S> getSuggestionResolver() {
        return this.typeResolver.getSuggestionResolver();
    }

    @Override
    public boolean matchesInput(int rawPosition, Context<S> context, CommandParameter<S> parameter) {
        return this.typeResolver.matchesInput(rawPosition, context, parameter);
    }

    @Override
    public OptionalValueSupplier supplyDefaultValue() {
        return this.typeResolver.supplyDefaultValue();
    }

    @Override
    public boolean isGreedy(CommandParameter<S> parameter) {
        return this.typeResolver.isGreedy(parameter);
    }
}

