/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.lang.reflect.Type;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.parse.InvalidEnumException;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

public final class ParameterEnum<S extends Source>
extends BaseParameterType<S, Enum<?>> {
    public ParameterEnum(TypeWrap<Enum<?>> typeWrap) {
        super(typeWrap.getType());
        Class type = (Class)typeWrap.getType();
        for (Enum constantEnum : (Enum[])type.getEnumConstants()) {
            this.suggestions.add(constantEnum.name());
        }
    }

    @Override
    @NotNull
    public Enum<?> resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, @NotNull String input) throws ImperatException {
        Type enumType = commandInputStream.currentParameter().filter(param -> TypeUtility.matches(this.type, Enum.class)).map(CommandParameter::valueType).orElse(this.type);
        try {
            return Enum.valueOf((Class)enumType, input);
        }
        catch (EnumConstantNotPresentException | IllegalArgumentException ex) {
            throw new InvalidEnumException(input, (Class)enumType, context);
        }
    }

    @Override
    public boolean matchesInput(int rawPosition, Context<S> context, CommandParameter<S> parameter) {
        String input = (String)context.arguments().get(rawPosition);
        if (input == null) {
            return false;
        }
        try {
            if (!TypeWrap.of(this.type).isSubtypeOf((Type)((Object)Enum.class))) {
                return true;
            }
            Enum.valueOf((Class)this.type, input);
            return true;
        }
        catch (EnumConstantNotPresentException | IllegalArgumentException ex) {
            return false;
        }
    }
}

