/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.suggestions.CompletionArg;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.MissingFlagInputException;
import studio.mevera.imperat.resolvers.SuggestionResolver;

public class ParameterFlag<S extends Source>
extends BaseParameterType<S, ExtractedInputFlag> {
    private final FlagData<S> flagData;

    protected ParameterFlag(FlagData<S> flagData) {
        this.flagData = flagData;
        this.suggestions.add("-" + flagData.name());
        for (String alias : flagData.aliases()) {
            this.suggestions.add("-" + alias);
        }
    }

    public ExtractedInputFlag resolveFreeFlag(ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, FlagData<S> freeFlag) throws ImperatException {
        String rawFlag = commandInputStream.currentRaw().orElse(null);
        if (rawFlag == null) {
            throw new IllegalArgumentException();
        }
        String rawInput = null;
        Boolean input = null;
        if (!freeFlag.isSwitch()) {
            ParameterType inputType = freeFlag.inputType();
            rawInput = commandInputStream.popRaw().orElse(null);
            if (rawInput != null) {
                assert (inputType != null);
                input = inputType.resolve(context, commandInputStream, commandInputStream.readInput());
            }
        } else {
            input = true;
        }
        return new ExtractedInputFlag(freeFlag, rawFlag, rawInput, input);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public ExtractedInputFlag resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, @NotNull String rawFlag) throws ImperatException {
        void var7_12;
        CommandParameter<S> currentParameter = commandInputStream.currentParameterIfPresent();
        if (currentParameter == null) {
            return null;
        }
        if (!currentParameter.isFlag()) {
            throw new IllegalArgumentException();
        }
        FlagParameter<S> flagParameter = currentParameter.asFlagParameter();
        String rawInput = null;
        if (!flagParameter.isSwitch()) {
            String defValue;
            ParameterType inputType = flagParameter.flagData().inputType();
            rawInput = commandInputStream.popRaw().orElse(null);
            if (rawInput == null) throw new MissingFlagInputException(flagParameter, rawFlag, context);
            assert (inputType != null);
            Object t = inputType.resolve(context, commandInputStream, rawInput);
            if (t != null || flagParameter.getDefaultValueSupplier().isEmpty() || (defValue = flagParameter.getDefaultValueSupplier().supply(context, flagParameter)) == null) return new ExtractedInputFlag(flagParameter.flagData(), rawFlag, rawInput, var7_12);
            Object t2 = inputType.resolve(context, commandInputStream, defValue);
            return new ExtractedInputFlag(flagParameter.flagData(), rawFlag, rawInput, var7_12);
        } else {
            Boolean bl = true;
        }
        return new ExtractedInputFlag(flagParameter.flagData(), rawFlag, rawInput, var7_12);
    }

    @Override
    public boolean matchesInput(int rawPosition, Context<S> context, CommandParameter<S> parameter) {
        String input = context.arguments().getOr(rawPosition, null);
        if (input == null) {
            return false;
        }
        if (!parameter.isFlag()) {
            throw new IllegalArgumentException(String.format("Parameter '%s' isn't a flag while having parameter type of '%s'", parameter.format(), "ParameterFlag"));
        }
        FlagParameter<S> flagParameter = parameter.asFlagParameter();
        ParameterType inputType = flagParameter.flagData().inputType();
        boolean matchesForFlagInput = true;
        int nextPos = rawPosition + 1;
        if (inputType != null && !flagParameter.isSwitch() && nextPos < context.arguments().size()) {
            String nextInput = context.arguments().getOr(nextPos, null);
            matchesForFlagInput = nextInput == null ? false : inputType.matchesInput(nextPos, context, parameter);
        }
        return parameter.asFlagParameter().flagData().acceptsInput(input) && matchesForFlagInput;
    }

    @Override
    public SuggestionResolver<S> getSuggestionResolver() {
        return (ctx, param) -> {
            if (!param.isFlag()) {
                return Collections.emptyList();
            }
            FlagParameter flagParameter = param.asFlagParameter();
            CompletionArg argToComplete = ctx.getArgToComplete();
            if (flagParameter.isSwitch() || argToComplete.index() == 0 || !flagParameter.flagData().acceptsInput((String)ctx.arguments().get(argToComplete.index() - 1))) {
                return this.suggestions;
            }
            SuggestionResolver specificParamType = flagParameter.inputSuggestionResolver();
            if (specificParamType != null) {
                return specificParamType.autoComplete(ctx, param);
            }
            ParameterType flagInputValueType = ctx.imperatConfig().getParameterType(flagParameter.inputValueType());
            if (flagInputValueType != null) {
                return flagInputValueType.getSuggestionResolver().autoComplete(ctx, param);
            }
            return Collections.emptyList();
        };
    }

    @Override
    public int getConsumedArguments() {
        return this.flagData.isSwitch() ? 1 : 2;
    }
}

