/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.parse.InvalidNumberFormatException;
import studio.mevera.imperat.util.TypeUtility;

public abstract class ParameterNumber<S extends Source, N extends Number>
extends BaseParameterType<S, N> {
    protected ParameterNumber() {
    }

    static <S extends Source, N extends Number> ParameterNumber<S, N> from(Class<N> numType) {
        if (TypeUtility.matches(numType, Integer.class)) {
            return new ParameterInt();
        }
        if (TypeUtility.matches(numType, Long.class)) {
            return new ParameterLong();
        }
        if (TypeUtility.matches(numType, Float.class)) {
            return new ParameterFloat();
        }
        if (TypeUtility.matches(numType, Double.class)) {
            return new ParameterDouble();
        }
        throw new IllegalArgumentException("Unsupported number type: " + numType.getTypeName());
    }

    @Override
    @Nullable
    public N resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> commandInputStream, @NotNull String input) throws ImperatException {
        try {
            return this.parse(input);
        }
        catch (NumberFormatException ex) {
            throw new InvalidNumberFormatException(input, ex, this.display(), this.wrappedType(), context);
        }
    }

    @Override
    public boolean matchesInput(int rawPosition, Context<S> context, CommandParameter<S> parameter) {
        String input = (String)context.arguments().get(rawPosition);
        if (input == null) {
            return false;
        }
        try {
            this.parse(input);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public abstract String display();

    public abstract N parse(String var1) throws NumberFormatException;

    static class ParameterInt<S extends Source>
    extends ParameterNumber<S, Integer> {
        protected ParameterInt() {
        }

        @Override
        public String display() {
            return "integer";
        }

        @Override
        public Integer parse(String input) throws NumberFormatException {
            return Integer.parseInt(input);
        }
    }

    static class ParameterLong<S extends Source>
    extends ParameterNumber<S, Long> {
        protected ParameterLong() {
        }

        @Override
        public String display() {
            return "long";
        }

        @Override
        public Long parse(String input) throws NumberFormatException {
            return Long.parseLong(input);
        }
    }

    static class ParameterFloat<S extends Source>
    extends ParameterNumber<S, Float> {
        protected ParameterFloat() {
        }

        @Override
        public String display() {
            return "float";
        }

        @Override
        public Float parse(String input) throws NumberFormatException {
            return Float.valueOf(Float.parseFloat(input));
        }
    }

    static class ParameterDouble<S extends Source>
    extends ParameterNumber<S, Double> {
        protected ParameterDouble() {
        }

        @Override
        public String display() {
            return "double";
        }

        @Override
        public Double parse(String input) throws NumberFormatException {
            return Double.parseDouble(input);
        }
    }
}

