/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.parameters.type;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.BaseParameterType;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.StringUtils;

public final class ParameterString<S extends Source>
extends BaseParameterType<S, String> {
    ParameterString() {
    }

    @Override
    @NotNull
    public String resolve(@NotNull ExecutionContext<S> context, @NotNull CommandInputStream<S> inputStream, @NotNull String input) throws ImperatException {
        CommandParameter parameter = inputStream.currentParameter().orElse(null);
        if (this.canUseFastPath(parameter, input)) {
            return input;
        }
        return this.resolveWithPrecision(inputStream, input, parameter);
    }

    private boolean canUseFastPath(CommandParameter<S> parameter, String input) {
        if (input == null || input.isEmpty()) {
            return false;
        }
        if (parameter != null && parameter.isGreedyString()) {
            return false;
        }
        return !StringUtils.isQuoteChar(input.charAt(0));
    }

    private String resolveWithPrecision(CommandInputStream<S> inputStream, String input, CommandParameter<S> parameter) {
        Character next;
        StringBuilder builder = new StringBuilder();
        Character current = inputStream.currentLetter().orElse(null);
        if (current == null) {
            return input;
        }
        if (parameter != null && parameter.isGreedyString()) {
            this.handleGreedyOptimized(builder, inputStream);
            return builder.toString();
        }
        while ((next = (Character)inputStream.popLetter().orElse(null)) != null) {
            builder.append(next);
            if (inputStream.isCurrentRawInputAvailable() && inputStream.peekLetter().map(ch -> !StringUtils.isQuoteChar(ch.charValue())).orElse(false).booleanValue()) continue;
        }
        return builder.toString();
    }

    private void handleGreedyOptimized(StringBuilder builder, CommandInputStream<S> inputStream) {
        String nextRaw;
        while (inputStream.isCurrentRawInputAvailable() && (nextRaw = (String)inputStream.currentRaw().orElse(null)) != null) {
            builder.append(nextRaw);
            if (inputStream.peekRaw().isPresent()) {
                builder.append(" ");
            }
            inputStream.skipRaw();
        }
    }

    @Override
    public boolean isGreedy(CommandParameter<S> parameter) {
        return parameter.isGreedyString();
    }
}

