/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.processors;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.Queue;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.processors.ChainImpl;
import studio.mevera.imperat.command.processors.CommandPostProcessor;
import studio.mevera.imperat.command.processors.CommandPreProcessor;
import studio.mevera.imperat.command.processors.CommandProcessor;
import studio.mevera.imperat.context.Source;

public interface CommandProcessingChain<S extends Source, P extends CommandProcessor<S>>
extends Iterable<P> {
    @NotNull
    public Queue<P> getProcessors();

    public void reset();

    public void add(P var1);

    public static <S extends Source> Builder<S, CommandPreProcessor<S>> preProcessors() {
        return new Builder();
    }

    public static <S extends Source> Builder<S, CommandPostProcessor<S>> postProcessors() {
        return new Builder();
    }

    public static final class Builder<S extends Source, P extends CommandProcessor<S>> {
        private final PriorityQueue<P> processors = new PriorityQueue<CommandProcessor>(Comparator.comparingInt(CommandProcessor::priority));

        public Builder<S, P> then(P processor) {
            this.processors.offer(processor);
            return this;
        }

        public CommandProcessingChain<S, P> build() {
            return new ChainImpl(this.processors);
        }
    }
}

