/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.suggestions;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.Imperat;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.suggestions.CompletionArg;
import studio.mevera.imperat.command.suggestions.NativeAutoCompleter;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;

@ApiStatus.AvailableSince(value="1.0.0")
public abstract class AutoCompleter<S extends Source> {
    protected final Command<S> command;

    protected AutoCompleter(Command<S> command) {
        this.command = command;
    }

    public static <S extends Source> AutoCompleter<S> createNative(Command<S> command) {
        return new NativeAutoCompleter<S>(command);
    }

    @NotNull
    public static CompletionArg getLastArg(ArgumentInput argumentInput) {
        if (argumentInput.isEmpty()) {
            return CompletionArg.EMPTY;
        }
        return new CompletionArg((String)argumentInput.getLast(), argumentInput.size() - 1);
    }

    public final CompletableFuture<List<String>> autoComplete(Imperat<S> dispatcher, S sender, String label, String[] args) {
        return CompletableFuture.supplyAsync(() -> {
            StringBuilder builder = new StringBuilder();
            for (String a : args) {
                builder.append(a).append(" ");
            }
            if (!builder.isEmpty()) {
                builder.deleteCharAt(builder.length() - 1);
            }
            boolean endWithSpace = builder.charAt(builder.length() - 1) == ' ';
            ArgumentInput queue = ArgumentInput.parseAutoCompletion(builder.toString(), endWithSpace);
            return dispatcher.config().getContextFactory().createSuggestionContext(dispatcher, (Source)sender, (Command<Source>)this.command, label, queue);
        }).thenCompose(context -> this.autoComplete((SuggestionContext<S>)context).exceptionally(ex -> {
            dispatcher.config().handleExecutionThrowable(ex, context, AutoCompleter.class, "autoComplete(dispatcher, sender, args)");
            return Collections.emptyList();
        }));
    }

    public abstract CompletableFuture<List<String>> autoComplete(SuggestionContext<S> var1);
}

