/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.suggestions;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.resolvers.SuggestionResolver;

@ApiStatus.Internal
public final class SuggestionResolverRegistry<S extends Source> {
    private final Map<String, SuggestionResolver<S>> resolversPerName;
    private final EnumSuggestionResolver enumSuggestionResolver = new EnumSuggestionResolver();
    private final ImperatConfig<S> imperat;

    private SuggestionResolverRegistry(ImperatConfig<S> imperat) {
        this.imperat = imperat;
        this.resolversPerName = new HashMap<String, SuggestionResolver<S>>();
    }

    public static <S extends Source> SuggestionResolverRegistry<S> createDefault(ImperatConfig<S> imperat) {
        return new SuggestionResolverRegistry<S>(imperat);
    }

    public EnumSuggestionResolver getEnumSuggestionResolver() {
        return this.enumSuggestionResolver;
    }

    public void registerNamedResolver(String name, SuggestionResolver<S> suggestionResolver) {
        this.resolversPerName.put(name, suggestionResolver);
    }

    @Nullable
    public SuggestionResolver<S> getResolverByName(String name) {
        return this.resolversPerName.get(name);
    }

    public final class EnumSuggestionResolver
    implements SuggestionResolver<S> {
        private final Map<Type, List<String>> PRE_LOADED_ENUMS = new HashMap<Type, List<String>>();

        public void registerEnumResolver(Type raw) {
            Class enumClass = (Class)raw;
            this.PRE_LOADED_ENUMS.computeIfAbsent(raw, v -> Arrays.stream((Enum[])enumClass.getEnumConstants()).map(Enum::name).toList());
        }

        private Optional<List<String>> getResults(Type type) {
            return Optional.ofNullable(this.PRE_LOADED_ENUMS.get(type));
        }

        @Override
        public List<String> autoComplete(SuggestionContext<S> context, CommandParameter<S> parameter) {
            Type type = parameter.valueType();
            return this.getResults(type).orElseGet(() -> {
                this.registerEnumResolver(type);
                return this.getResults(type).orElse(Collections.emptyList());
            });
        }
    }
}

