/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.command.tree.ParameterNode;
import studio.mevera.imperat.context.Source;

public final class CommandPathSearch<S extends Source> {
    private final CommandNode<S> root;
    private ParameterNode<S, ?> lastNode;
    @NotNull
    private ParameterNode<S, ?> lastCommandNode;
    private CommandUsage<S> directUsage;
    private CommandUsage<S> closestUsage;
    private Result result;

    private CommandPathSearch(@NotNull CommandNode<S> root, Result result) {
        this.root = root;
        this.lastCommandNode = root;
        this.result = result;
    }

    private CommandPathSearch(Result result, @NotNull CommandNode<S> root, ParameterNode<S, ?> lastNode, CommandUsage<S> directUsage) {
        this.root = root;
        this.result = result;
        this.lastNode = lastNode;
        this.directUsage = directUsage;
        this.lastCommandNode = root;
    }

    public static <S extends Source> CommandPathSearch<S> of(CommandNode<S> root, Result result) {
        return new CommandPathSearch<S>(root, result);
    }

    public static <S extends Source> CommandPathSearch<S> unknown(CommandNode<S> root) {
        return CommandPathSearch.of(root, Result.UNKNOWN);
    }

    public static <S extends Source> CommandPathSearch<S> freshlyNew(Command<S> command) {
        CommandPathSearch<S> dispatch = CommandPathSearch.of(command.tree().rootNode(), Result.UNKNOWN);
        dispatch.append(command.tree().rootNode());
        dispatch.setDirectUsage(command.getDefaultUsage());
        return dispatch;
    }

    public static <S extends Source> CommandPathSearch<S> paused(Command<S> command) {
        CommandPathSearch<S> dispatch = CommandPathSearch.of(command.tree().rootNode(), Result.PAUSE);
        Command<S> target = null;
        if (command.tree() != null) {
            target = command;
        } else {
            Command<S> root;
            for (root = command; root != null && root.parent() != null; root = root.parent()) {
            }
            if (root != null && root != command) {
                target = root;
            }
        }
        if (target != null) {
            dispatch.append(target.tree().rootNode());
            dispatch.setDirectUsage(target.getDefaultUsage());
        }
        return dispatch;
    }

    public void append(ParameterNode<S, ?> node) {
        if (node == null) {
            return;
        }
        if (node.isCommand()) {
            this.lastCommandNode = node;
        }
        this.lastNode = node;
    }

    @Nullable
    public ParameterNode<S, ?> getLastNode() {
        return this.lastNode;
    }

    @Nullable
    public CommandUsage<S> getFoundUsage() {
        return this.directUsage;
    }

    public Result getResult() {
        return this.result;
    }

    public CommandUsage<S> getClosestUsage() {
        if (this.closestUsage == null) {
            this.closestUsage = this.computeClosestUsage();
        }
        return this.closestUsage;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void setDirectUsage(CommandUsage<S> directUsage) {
        this.directUsage = directUsage;
    }

    private CommandUsage<S> computeClosestUsage() {
        if (this.directUsage != null && this.lastNode != null && this.lastNode.isLast()) {
            return this.directUsage;
        }
        this.closestUsage = this.closestUsageLookup();
        return this.closestUsage;
    }

    private CommandUsage<S> closestUsageLookup() {
        if (this.lastNode == null) {
            return null;
        }
        CommandUsage<S> closestUsage = null;
        for (ParameterNode<S, ?> curr = this.lastNode; curr != null; curr = curr.getTopChild()) {
            if (!curr.isExecutable()) continue;
            closestUsage = curr.getExecutableUsage();
            break;
        }
        if (closestUsage == null) {
            closestUsage = this.lastCommandNode.isExecutable() ? this.lastCommandNode.getExecutableUsage() : ((Command)((CommandNode)this.lastCommandNode).getData()).getDefaultUsage();
        }
        return closestUsage;
    }

    public CommandPathSearch<S> copy() {
        return new CommandPathSearch<S>(this.result, this.root, this.lastNode, this.directUsage);
    }

    @NotNull
    public CommandNode<S> getLastCommandNode() {
        return (CommandNode)this.lastCommandNode;
    }

    public static enum Result {
        PAUSE,
        COMPLETE,
        UNKNOWN,
        FAILURE;


        public boolean isStoppable() {
            return this == COMPLETE || this == PAUSE;
        }
    }
}

