/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree;

import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.command.tree.StandardCommandTree;
import studio.mevera.imperat.command.tree.help.HelpEntryList;
import studio.mevera.imperat.command.tree.help.HelpQuery;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;

public interface CommandTree<S extends Source> {
    @NotNull
    public Command<S> root();

    @NotNull
    public CommandNode<S> rootNode();

    @NotNull
    public CommandNode<S> uniqueVersionedTree();

    public int size();

    public int uniqueSize();

    public void parseUsage(@NotNull CommandUsage<S> var1);

    public void computePermissions();

    @Nullable
    public String getAutoAssignedPermission(@NotNull CommandParameter<S> var1);

    @NotNull
    public CommandPathSearch<S> contextMatch(Context<S> var1, @NotNull ArgumentInput var2);

    @NotNull
    public List<String> tabComplete(@NotNull SuggestionContext<S> var1);

    public HelpEntryList<S> queryHelp(@NotNull HelpQuery<S> var1);

    public Set<CommandUsage<S>> getClosestUsages(Context<S> var1);

    public static <S extends Source> CommandTree<S> create(ImperatConfig<S> imperatConfig, Command<S> command) {
        return new StandardCommandTree<S>(imperatConfig, command);
    }

    public static <S extends Source> CommandTree<S> parsed(ImperatConfig<S> imperatConfig, Command<S> command) {
        StandardCommandTree<S> tree = new StandardCommandTree<S>(imperatConfig, command);
        tree.parseCommandUsages();
        return tree;
    }
}

