/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.command.tree.ArgumentNode;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;

public abstract class ParameterNode<S extends Source, T extends CommandParameter<S>> {
    @NotNull
    protected final T data;
    @Nullable
    protected CommandUsage<S> executableUsage;
    private final LinkedList<ParameterNode<S, ?>> nextNodes = new LinkedList();
    private final Deque<ParameterType<S, ?>> supportedTypes = new ArrayDeque();
    private final int depth;
    @Nullable
    private final ParameterNode<S, ?> parent;
    private String permission;
    private static final ParameterType<?, ?> DEFAULT_PARAM_TYPE = ParameterTypes.string();

    protected ParameterNode(@Nullable ParameterNode<S, ?> parent, @NotNull T data, int depth, @Nullable CommandUsage<S> executableUsage) {
        this.parent = parent;
        this.data = data;
        this.depth = depth;
        this.executableUsage = executableUsage;
        this.permission = data.getSinglePermission();
        if (!this.isCommand() && !this.isFlag()) {
            this.supportedTypes.add(DEFAULT_PARAM_TYPE);
        }
        if (!data.type().equalsExactly(DEFAULT_PARAM_TYPE.type())) {
            this.supportedTypes.add(data.type());
        }
    }

    public static <S extends Source> CommandNode<S> createCommandNode(@Nullable ParameterNode<S, ?> parent, @NotNull Command<S> data, int depth, @Nullable CommandUsage<S> executableUsage) {
        return new CommandNode<S>(parent, data, depth, executableUsage);
    }

    public static <S extends Source> ArgumentNode<S> createArgumentNode(ParameterNode<S, ?> parent, CommandParameter<S> data, int depth, @Nullable CommandUsage<S> executableUsage) {
        return new ArgumentNode<S>(parent, data, depth, executableUsage);
    }

    public String getPermission() {
        return this.permission;
    }

    public void setPermission(String permission) {
        this.permission = permission;
    }

    public int getDepth() {
        return this.depth;
    }

    @Nullable
    public CommandUsage<S> getExecutableUsage() {
        return this.executableUsage;
    }

    public void setExecutableUsage(@Nullable CommandUsage<S> executableUsage) {
        this.executableUsage = executableUsage;
    }

    public boolean isExecutable() {
        return this.executableUsage != null;
    }

    @NotNull
    public T getData() {
        return this.data;
    }

    public void addChild(ParameterNode<S, ?> node) {
        if (this.nextNodes.contains(node)) {
            return;
        }
        int newNodePriority = node.priority();
        if (this.nextNodes.isEmpty()) {
            this.nextNodes.add(node);
            return;
        }
        if (newNodePriority < this.nextNodes.getFirst().priority()) {
            this.nextNodes.addFirst(node);
            return;
        }
        if (newNodePriority >= this.nextNodes.getLast().priority()) {
            this.nextNodes.addLast(node);
            return;
        }
        ListIterator<ParameterNode<S, ?>> iterator = this.nextNodes.listIterator();
        while (iterator.hasNext()) {
            ParameterNode existingNode = (ParameterNode)iterator.next();
            if (newNodePriority >= existingNode.priority()) continue;
            iterator.previous();
            iterator.add(node);
            return;
        }
    }

    public LinkedList<ParameterNode<S, ?>> getChildren() {
        return this.nextNodes;
    }

    public boolean matchesInput(int depth, Context<S> ctx) {
        return this.matchesInput(depth, ctx, false);
    }

    public boolean matchesInput(int depth, Context<S> ctx, boolean strict) {
        if (strict) {
            ParameterType<S, ?> primaryType = this.getPrimaryType();
            return primaryType != null && this.matchesInput(primaryType, depth, ctx);
        }
        Iterator<ParameterType<S, ?>> iterator = this.supportedTypes.descendingIterator();
        while (iterator.hasNext()) {
            ParameterType<S, ?> type = iterator.next();
            if (!this.matchesInput(type, depth, ctx)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesInput(ParameterType<S, ?> type, int depth, Context<S> ctx) {
        return type.matchesInput(depth, ctx, (CommandParameter<S>)this.data);
    }

    public void addSupportedType(ParameterType<S, ?> type) {
        if (!this.supportedTypes.contains(type)) {
            this.supportedTypes.add(type);
        }
    }

    public void removeSupportedType(ParameterType<S, ?> type) {
        this.supportedTypes.remove(type);
    }

    public Deque<ParameterType<S, ?>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Nullable
    public ParameterType<S, ?> getPrimaryType() {
        return this.supportedTypes.peekLast();
    }

    public abstract String format();

    public boolean isLast() {
        return this.nextNodes.isEmpty();
    }

    public abstract int priority();

    public boolean isGreedyParam() {
        return this.data.isGreedy();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isOptional() {
        ParameterNode parameterNode = this;
        if (!(parameterNode instanceof ArgumentNode)) return false;
        ArgumentNode param = (ArgumentNode)parameterNode;
        if (!param.data.isOptional()) return false;
        return true;
    }

    @Nullable
    public ParameterNode<S, ?> getChild(Predicate<ParameterNode<S, ?>> predicate) {
        for (ParameterNode parameterNode : this.getChildren()) {
            if (!predicate.test(parameterNode)) continue;
            return parameterNode;
        }
        return null;
    }

    public ParameterNode<S, ?> getNextCommandChild() {
        return this.getChild(child -> child instanceof CommandNode);
    }

    public ParameterNode<S, ?> getNextParameterChild() {
        return this.getChild(child -> true);
    }

    public boolean isRequired() {
        return this.data.isRequired();
    }

    public boolean isCommand() {
        return this instanceof CommandNode || this.data.isCommand();
    }

    public boolean isTrueFlag() {
        return this.data.isFlag() && !this.data.asFlagParameter().isSwitch();
    }

    public boolean isFlag() {
        return this.data.isFlag();
    }

    @Nullable
    public ParameterNode<S, ?> getParent() {
        return this.parent;
    }

    @Nullable
    public ParameterNode<S, ?> getTopChild() {
        if (this.nextNodes.isEmpty()) {
            return null;
        }
        return this.nextNodes.getFirst();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public int getConsumedArguments() {
        int incrementation = this.data.type().getConsumedArguments();
        if (incrementation < 1) {
            incrementation = 1;
        }
        return incrementation;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParameterNode)) {
            return false;
        }
        ParameterNode that = (ParameterNode)o;
        return Objects.equals(this.parent, that.parent) && Objects.equals(this.data.name(), that.data.name()) && this.depth == that.depth && Objects.equals(this.nextNodes, that.nextNodes);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.data.name(), this.depth, this.nextNodes);
    }
}

