/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.ImperatConfig;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.command.tree.CommandTree;
import studio.mevera.imperat.command.tree.ParameterNode;
import studio.mevera.imperat.command.tree.help.HelpEntryFactory;
import studio.mevera.imperat.command.tree.help.HelpEntryList;
import studio.mevera.imperat.command.tree.help.HelpFilter;
import studio.mevera.imperat.command.tree.help.HelpQuery;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.SuggestionContext;
import studio.mevera.imperat.resolvers.PermissionChecker;
import studio.mevera.imperat.resolvers.SuggestionResolver;
import studio.mevera.imperat.util.TypeUtility;

final class StandardCommandTree<S extends Source>
implements CommandTree<S> {
    private final Command<S> rootCommand;
    final CommandNode<S> root;
    final CommandNode<S> uniqueRoot;
    private int size;
    private int uniqueSize;
    private static final int INITIAL_SUGGESTIONS_CAPACITY = 20;
    private final ThreadLocal<ArrayList<ParameterNode<S, ?>>> pathBuffer = ThreadLocal.withInitial(() -> new ArrayList(16));
    private final ThreadLocal<ArrayList<CommandParameter<S>>> paramBuffer = ThreadLocal.withInitial(() -> new ArrayList(8));
    private final ImperatConfig<S> imperatConfig;
    @NotNull
    private final PermissionChecker<S> permissionChecker;
    private final HelpEntryFactory<S> helpEntryFactory = HelpEntryFactory.defaultFactory();
    private final Map<CommandParameter<S>, String> assignedPermissions = new HashMap<CommandParameter<S>, String>();

    StandardCommandTree(ImperatConfig<S> imperatConfig, Command<S> command) {
        this.rootCommand = command;
        this.root = ParameterNode.createCommandNode(null, command, -1, command.getDefaultUsage());
        this.imperatConfig = imperatConfig;
        this.permissionChecker = imperatConfig.getPermissionChecker();
        this.uniqueRoot = this.root.copy();
    }

    public void parseCommandUsages() {
        Collection usages = ((Command)this.root.data).usages();
        for (CommandUsage usage : usages) {
            this.parseUsage(usage);
        }
    }

    @Override
    @NotNull
    public Command<S> root() {
        return this.rootCommand;
    }

    @Override
    @NotNull
    public CommandNode<S> rootNode() {
        return this.root;
    }

    @Override
    @NotNull
    public CommandNode<S> uniqueVersionedTree() {
        return this.uniqueRoot;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int uniqueSize() {
        return this.uniqueSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parseUsage(@NotNull CommandUsage<S> usage) {
        Set<FlagData<S>> flags = usage.getUsedFreeFlags();
        for (FlagData<S> flag : flags) {
            this.rootCommand.registerFlag(flag);
        }
        List<CommandParameter<S>> parameters = usage.getParameters();
        if (usage.isDefault()) {
            this.root.setExecutableUsage(usage);
            this.uniqueRoot.setExecutableUsage(usage);
        }
        ArrayList<ParameterNode<S, ?>> path = this.pathBuffer.get();
        path.clear();
        path.add(this.root);
        try {
            this.addParametersToTree(this.root, usage, parameters, 0, path);
        }
        finally {
            path.clear();
        }
        this.addParametersWithoutOptionalBranchingToTree(this.uniqueRoot, usage, parameters, 0);
    }

    @Override
    public void computePermissions() {
        this.root.setPermission(this.rootCommand.getSinglePermission());
        this.uniqueRoot.setPermission(this.rootCommand.getSinglePermission());
        if (!this.imperatConfig.isAutoPermissionAssignMode()) {
            return;
        }
        String rootPerm = this.imperatConfig.getPermissionLoader().load(this.rootCommand);
        this.root.setPermission(rootPerm);
        for (ParameterNode parameterNode : this.root.getChildren()) {
            this.computePermissionsRecursive(parameterNode, new ArrayList(), rootPerm);
        }
    }

    @Override
    @Nullable
    public String getAutoAssignedPermission(@NotNull CommandParameter<S> commandParameter) {
        if (!this.imperatConfig.isAutoPermissionAssignMode()) {
            throw new IllegalStateException("APA mode must be enabled!");
        }
        return this.assignedPermissions.get(commandParameter);
    }

    private void computePermissionsRecursive(ParameterNode<S, ?> node, List<ParameterNode<S, ?>> pathNodes, String rootPermission) {
        ArrayList currentPath = new ArrayList(pathNodes);
        currentPath.add(node);
        if (node.getPermission() == null) {
            if (node.isExecutable() || node.isCommand()) {
                String permission = this.buildHierarchicalPermission(rootPermission, currentPath);
                this.imperatConfig.getPermissionAssigner().assign(node, permission);
                this.assignedPermissions.put((CommandParameter<S>)node.data, permission);
            } else {
                ParameterNode<S, ?> firstParentCmd;
                for (firstParentCmd = node; firstParentCmd != null && !firstParentCmd.isCommand(); firstParentCmd = firstParentCmd.getParent()) {
                }
                if (firstParentCmd == null) {
                    firstParentCmd = this.root;
                }
                this.imperatConfig.getPermissionAssigner().assign(node, firstParentCmd.getPermission());
                this.assignedPermissions.put((CommandParameter<S>)node.data, firstParentCmd.getPermission());
            }
        }
        if (!node.getChildren().isEmpty()) {
            for (ParameterNode parameterNode : node.getChildren()) {
                this.computePermissionsRecursive(parameterNode, currentPath, rootPermission);
            }
        }
    }

    private String buildHierarchicalPermission(String root, List<ParameterNode<S, ?>> pathNodes) {
        StringBuilder basePermission = new StringBuilder(root);
        for (ParameterNode<S, ?> node : pathNodes) {
            if (node.isOptional()) continue;
            String component = this.imperatConfig.getPermissionLoader().load((CommandParameter<S>)node.data);
            basePermission.append(this.imperatConfig.getPermissionAssigner().getPermissionDelimiter()).append(component);
        }
        ParameterNode<S, ?> currentNode = pathNodes.get(pathNodes.size() - 1);
        if (currentNode.isOptional()) {
            String component = this.imperatConfig.getPermissionLoader().load((CommandParameter<S>)currentNode.data);
            return String.valueOf(basePermission) + this.imperatConfig.getPermissionAssigner().getPermissionDelimiter() + component;
        }
        return basePermission.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParametersToTree(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> parameters, int index, List<ParameterNode<S, ?>> path) {
        int paramSize = parameters.size();
        if (index >= paramSize) {
            currentNode.setExecutableUsage(usage);
            return;
        }
        if (currentNode.isGreedyParam()) {
            if (!currentNode.isLast()) {
                throw new IllegalStateException("A greedy node '%s' is not the last argument!".formatted(currentNode.format()));
            }
            currentNode.setExecutableUsage(usage);
            return;
        }
        int flagSequenceEnd = this.findFlagSequenceEnd(parameters, index);
        if (flagSequenceEnd > index) {
            this.handleFlagSequenceOptimized(currentNode, usage, parameters, index, flagSequenceEnd, path);
            this.addParametersToTree(currentNode, usage, parameters, flagSequenceEnd, path);
            return;
        }
        CommandParameter<S> param = parameters.get(index);
        ParameterNode<S, ?> childNode = this.getOrCreateChildNode(currentNode, param, true);
        int pathSize = path.size();
        path.add(childNode);
        try {
            this.addParametersToTree(childNode, usage, parameters, index + 1, path);
            if (param.isOptional()) {
                this.addParametersToTree(currentNode, usage, parameters, index + 1, path.subList(0, pathSize));
            }
        }
        finally {
            if (path.size() > pathSize) {
                path.remove(pathSize);
            }
        }
    }

    private void addParametersWithoutOptionalBranchingToTree(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> parameters, int index) {
        int paramSize = parameters.size();
        if (index >= paramSize) {
            currentNode.setExecutableUsage(usage);
            return;
        }
        if (currentNode.isGreedyParam()) {
            if (!currentNode.isLast()) {
                throw new IllegalStateException("A greedy node '%s' is not the last argument!".formatted(currentNode.format()));
            }
            currentNode.setExecutableUsage(usage);
            return;
        }
        CommandParameter<S> param = parameters.get(index);
        ParameterNode<S, ?> childNode = this.getOrCreateChildNode(currentNode, param, true);
        this.addParametersWithoutOptionalBranchingToTree(childNode, usage, parameters, index + 1);
    }

    private int findFlagSequenceEnd(List<CommandParameter<S>> parameters, int startIndex) {
        CommandParameter<S> param;
        if (startIndex >= parameters.size()) {
            return startIndex;
        }
        CommandParameter<S> startParam = parameters.get(startIndex);
        if (!startParam.isFlag() || !startParam.isOptional()) {
            return startIndex;
        }
        int end = startIndex + 1;
        for (int i = startIndex + 1; i < parameters.size() && (param = parameters.get(i)).isFlag() && param.isOptional(); ++i) {
            end = i + 1;
        }
        return end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFlagSequenceOptimized(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, int flagStart, int flagEnd, List<ParameterNode<S, ?>> path) {
        ArrayList<CommandParameter<S>> flagParams = this.paramBuffer.get();
        flagParams.clear();
        try {
            for (int i = flagStart; i < flagEnd; ++i) {
                flagParams.add(allParameters.get(i));
            }
            this.generateAllFlagCombinations(currentNode, usage, allParameters, flagParams, flagEnd, path);
        }
        finally {
            flagParams.clear();
        }
    }

    private void generateAllFlagCombinations(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, List<CommandParameter<S>> flagParams, int nextIndex, List<ParameterNode<S, ?>> basePath) {
        int flagCount = flagParams.size();
        int totalCombinations = 1 << flagCount;
        for (int mask = 0; mask < totalCombinations; ++mask) {
            ArrayList<CommandParameter<S>> subset = new ArrayList<CommandParameter<S>>();
            for (int i = 0; i < flagCount; ++i) {
                if ((mask & 1 << i) == 0) continue;
                subset.add(flagParams.get(i));
            }
            if (subset.isEmpty()) {
                if (nextIndex < allParameters.size()) {
                    this.addParametersToTree(currentNode, usage, allParameters, nextIndex, basePath);
                    continue;
                }
                currentNode.setExecutableUsage(usage);
                continue;
            }
            this.generatePermutationsForSubset(currentNode, usage, allParameters, subset, nextIndex, basePath);
        }
    }

    private void generatePermutationsForSubset(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, List<CommandParameter<S>> subset, int nextIndex, List<ParameterNode<S, ?>> basePath) {
        if (subset.size() <= 3) {
            this.generateSmallPermutationsForSubset(currentNode, usage, allParameters, subset, nextIndex, basePath);
        } else {
            this.generateLargePermutationsForSubset(currentNode, usage, allParameters, subset, nextIndex, basePath);
        }
    }

    private void generateSmallPermutationsForSubset(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, List<CommandParameter<S>> subset, int nextIndex, List<ParameterNode<S, ?>> basePath) {
        int size = subset.size();
        if (size == 1) {
            this.processPermutationPath(currentNode, usage, allParameters, subset, nextIndex, basePath);
        } else if (size == 2) {
            CommandParameter<S> flag1 = subset.get(0);
            CommandParameter<S> flag2 = subset.get(1);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag1, flag2), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag2, flag1), nextIndex, basePath);
        } else if (size == 3) {
            CommandParameter<S> flag1 = subset.get(0);
            CommandParameter<S> flag2 = subset.get(1);
            CommandParameter<S> flag3 = subset.get(2);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag1, flag2, flag3), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag1, flag3, flag2), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag2, flag1, flag3), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag2, flag3, flag1), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag3, flag1, flag2), nextIndex, basePath);
            this.processPermutationPath(currentNode, usage, allParameters, List.of(flag3, flag2, flag1), nextIndex, basePath);
        }
    }

    private void generateLargePermutationsForSubset(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, List<CommandParameter<S>> subset, int nextIndex, List<ParameterNode<S, ?>> basePath) {
        ArrayList<CommandParameter<S>> workingSubset = new ArrayList<CommandParameter<S>>(subset);
        int n = workingSubset.size();
        int[] indices = new int[n];
        this.processPermutationPath(currentNode, usage, allParameters, new ArrayList<CommandParameter<S>>(workingSubset), nextIndex, basePath);
        int i = 0;
        while (i < n) {
            if (indices[i] < i) {
                if (i % 2 == 0) {
                    Collections.swap(workingSubset, 0, i);
                } else {
                    Collections.swap(workingSubset, indices[i], i);
                }
                this.processPermutationPath(currentNode, usage, allParameters, new ArrayList<CommandParameter<S>>(workingSubset), nextIndex, basePath);
                int n2 = i;
                indices[n2] = indices[n2] + 1;
                i = 0;
                continue;
            }
            indices[i] = 0;
            ++i;
        }
    }

    private void processPermutationPath(ParameterNode<S, ?> currentNode, CommandUsage<S> usage, List<CommandParameter<S>> allParameters, List<CommandParameter<S>> permutation, int nextIndex, List<ParameterNode<S, ?>> basePath) {
        ParameterNode<S, ?> nodePointer = currentNode;
        ArrayList updatedPath = new ArrayList(basePath);
        for (int i = 0; i < permutation.size(); ++i) {
            CommandParameter<S> flagParam = permutation.get(i);
            ParameterNode<S, ?> flagNode = this.getOrCreateChildNode(nodePointer, flagParam, false);
            updatedPath.add(flagNode);
            nodePointer = flagNode;
            if (!this.areAllRemainingParametersOptional(allParameters, nextIndex) || !this.areAllRemainingFlagsInPermutationOptional(permutation, i + 1)) continue;
            flagNode.setExecutableUsage(usage);
        }
        if (nextIndex < allParameters.size()) {
            this.addParametersToTree(nodePointer, usage, allParameters, nextIndex, updatedPath);
        } else {
            nodePointer.setExecutableUsage(usage);
        }
    }

    private boolean areAllRemainingParametersOptional(List<CommandParameter<S>> allParameters, int startIndex) {
        for (int i = startIndex; i < allParameters.size(); ++i) {
            if (allParameters.get(i).isOptional()) continue;
            return false;
        }
        return true;
    }

    private boolean areAllRemainingFlagsInPermutationOptional(List<CommandParameter<S>> permutation, int startIndex) {
        for (int i = startIndex; i < permutation.size(); ++i) {
            if (permutation.get(i).isOptional()) continue;
            return false;
        }
        return true;
    }

    private ParameterNode<S, ?> getOrCreateChildNode(ParameterNode<S, ?> parent, CommandParameter<S> param, boolean onlyUnique) {
        LinkedList<ParameterNode<S, ?>> children = parent.getChildren();
        String paramName = param.name();
        Type paramType = param.valueType();
        for (ParameterNode parameterNode : children) {
            if (!parameterNode.data.name().equalsIgnoreCase(paramName) || !TypeUtility.matches(parameterNode.data.valueType(), paramType)) continue;
            return parameterNode;
        }
        ParameterNode newNode = param.isCommand() ? ParameterNode.createCommandNode(parent, param.asCommand(), parent.getDepth() + 1, null) : ParameterNode.createArgumentNode(parent, param, parent.getDepth() + 1, null);
        parent.addChild(newNode);
        if (onlyUnique) {
            ++this.uniqueSize;
        } else {
            ++this.size;
        }
        return newNode;
    }

    @Override
    @NotNull
    public CommandPathSearch<S> contextMatch(Context<S> context, @NotNull ArgumentInput input) {
        CommandPathSearch dispatch = CommandPathSearch.unknown(this.root);
        dispatch.append(this.root);
        if (!this.hasPermission(context.source(), this.root)) {
            dispatch.setResult(CommandPathSearch.Result.PAUSE);
            dispatch.setDirectUsage(this.root.getExecutableUsage());
            return dispatch;
        }
        if (input.isEmpty()) {
            CommandPathSearch.Result result = !this.hasPermission(context.source(), this.root) ? CommandPathSearch.Result.PAUSE : CommandPathSearch.Result.COMPLETE;
            dispatch.setResult(result);
            dispatch.setDirectUsage(this.root.getExecutableUsage());
            return dispatch;
        }
        LinkedList rootChildren = this.root.getChildren();
        if (rootChildren.isEmpty()) {
            return dispatch;
        }
        boolean hasMatchingChild = false;
        boolean hasOptionalChild = false;
        for (ParameterNode parameterNode : rootChildren) {
            if (parameterNode.matchesInput(0, context)) {
                hasMatchingChild = true;
                break;
            }
            if (!parameterNode.isOptional()) continue;
            hasOptionalChild = true;
        }
        if (!(hasMatchingChild || hasOptionalChild || this.root.isGreedyParam())) {
            return dispatch;
        }
        CommandPathSearch bestMatch = dispatch;
        boolean bl = false;
        for (ParameterNode parameterNode : rootChildren) {
            int n;
            CommandPathSearch<S> result = this.dispatchNode(CommandPathSearch.unknown(this.root), context, input, parameterNode, 0);
            if (result.getResult().isStoppable()) {
                return result;
            }
            if (result.getLastNode() == null || result.getLastNode().getDepth() <= n) continue;
            bestMatch = result;
            n = result.getLastNode().getDepth();
        }
        return bestMatch;
    }

    @NotNull
    private CommandPathSearch<S> dispatchNode(CommandPathSearch<S> commandPathSearch, Context<S> context, ArgumentInput input, @NotNull ParameterNode<S, ?> currentNode, int depth) {
        boolean isLastDepth;
        int inputSize = input.size();
        boolean bl = isLastDepth = depth == inputSize - currentNode.getConsumedArguments();
        if (isLastDepth) {
            return this.handleLastDepth(commandPathSearch, context, currentNode, depth);
        }
        if (depth >= inputSize) {
            return commandPathSearch;
        }
        if (!this.hasPermission(context.source(), currentNode)) {
            commandPathSearch.setResult(CommandPathSearch.Result.PAUSE);
            if (currentNode.isExecutable()) {
                commandPathSearch.setDirectUsage(currentNode.getExecutableUsage());
            }
            return commandPathSearch;
        }
        if (currentNode.isGreedyParam()) {
            commandPathSearch.append(currentNode);
            commandPathSearch.setResult(CommandPathSearch.Result.COMPLETE);
            commandPathSearch.setDirectUsage(currentNode.getExecutableUsage());
            return commandPathSearch;
        }
        boolean nodeMatches = currentNode.matchesInput(depth, context, currentNode.isOptional());
        if (!nodeMatches) {
            return this.handleOptionalParameterSkipping(commandPathSearch, context, input, currentNode, depth);
        }
        commandPathSearch.append(currentNode);
        if (currentNode.isExecutable() && depth == inputSize - currentNode.getConsumedArguments()) {
            commandPathSearch.setResult(CommandPathSearch.Result.COMPLETE);
            commandPathSearch.setDirectUsage(currentNode.getExecutableUsage());
            return commandPathSearch;
        }
        LinkedList<ParameterNode<S, ?>> children = currentNode.getChildren();
        if (children.isEmpty()) {
            return commandPathSearch;
        }
        for (ParameterNode parameterNode : children) {
            CommandPathSearch<S> result = this.dispatchNode(commandPathSearch, context, input, parameterNode, depth + currentNode.getConsumedArguments());
            if (!result.getResult().isStoppable()) continue;
            return result;
        }
        return commandPathSearch;
    }

    private CommandPathSearch<S> handleLastDepth(CommandPathSearch<S> search, Context<S> context, ParameterNode<S, ?> node, int depth) {
        if (!node.matchesInput(depth, context)) {
            return search;
        }
        search.append(node);
        CommandPathSearch.Result result = CommandPathSearch.Result.COMPLETE;
        if (!this.hasPermission(context.source(), node)) {
            result = CommandPathSearch.Result.PAUSE;
        }
        if (!node.isExecutable()) {
            if (node.isCommand()) {
                search.setDirectUsage(node.data.asCommand().getDefaultUsage());
                search.setResult(result);
            }
            return search;
        }
        search.setDirectUsage(node.getExecutableUsage());
        search.setResult(result);
        return search;
    }

    private CommandPathSearch<S> handleOptionalParameterSkipping(CommandPathSearch<S> commandPathSearch, Context<S> context, ArgumentInput input, ParameterNode<S, ?> currentNode, int depth) {
        if (!currentNode.isOptional()) {
            return commandPathSearch;
        }
        if (currentNode.isExecutable()) {
            commandPathSearch.append(currentNode);
            commandPathSearch.setResult(CommandPathSearch.Result.COMPLETE);
            commandPathSearch.setDirectUsage(currentNode.getExecutableUsage());
            return commandPathSearch;
        }
        LinkedList<ParameterNode<S, ?>> children = currentNode.getChildren();
        for (ParameterNode parameterNode : children) {
            if (!this.hasPermission(context.source(), parameterNode) || !parameterNode.matchesInput(depth, context)) continue;
            return this.dispatchNode(commandPathSearch, context, input, parameterNode, depth);
        }
        return commandPathSearch;
    }

    @Override
    public HelpEntryList<S> queryHelp(@NotNull HelpQuery<S> query) {
        HelpEntryList results = new HelpEntryList();
        if (query.getLimit() <= 0) {
            return HelpEntryList.empty();
        }
        this.collectHelpEntries(this.uniqueRoot, query, results);
        return results;
    }

    private void collectHelpEntries(ParameterNode<S, ?> node, HelpQuery<S> query, HelpEntryList<S> results) {
        if (node.getDepth() > query.getMaxDepth()) {
            return;
        }
        if (results.size() >= query.getLimit()) {
            return;
        }
        if (!this.passesFilters(node, query.getFilters())) {
            return;
        }
        if (node.isExecutable() && (!node.isRoot() || query.getRootUsagePredicate().test(node.getExecutableUsage()))) {
            results.add(this.helpEntryFactory.createEntry(node));
        }
        for (ParameterNode parameterNode : node.getChildren()) {
            this.collectHelpEntries(parameterNode, query, results);
        }
    }

    private boolean passesFilters(ParameterNode<S, ?> node, Queue<HelpFilter<S>> filters) {
        for (HelpFilter helpFilter : filters) {
            if (helpFilter.filter(node)) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull SuggestionContext<S> context) {
        ArrayList<String> results = new ArrayList<String>(20);
        String prefix = context.getArgToComplete().value();
        boolean hasPrefix = prefix != null && !prefix.isBlank();
        return this.tabComplete$1(context, prefix, hasPrefix, results);
    }

    private List<String> tabComplete$1(SuggestionContext<S> context, String prefix, boolean hasPrefix, List<String> results) {
        if (!this.hasAutoCompletionPermission(context.source(), this.uniqueRoot)) {
            return Collections.emptyList();
        }
        for (ParameterNode parameterNode : this.uniqueRoot.getChildren()) {
            this.tabCompleteNode(parameterNode, context, 0, results);
        }
        return results.stream().filter(suggestion -> !hasPrefix || StandardCommandTree.fastStartsWith(suggestion, prefix)).toList();
    }

    private void tabCompleteNode(ParameterNode<S, ?> node, SuggestionContext<S> context, int inputDepth, List<String> results) {
        int lastIndex = context.getArgToComplete().index();
        if (inputDepth > lastIndex) {
            return;
        }
        if (inputDepth == lastIndex) {
            results.addAll(this.getResolverCached((CommandParameter<S>)node.data).autoComplete(context, (CommandParameter<S>)node.data));
            if (this.imperatConfig.isOptionalParameterSuggestionOverlappingEnabled() && node.isOptional() && !node.isTrueFlag()) {
                this.collectOverlappingSuggestions(node, node, context, results);
            }
        } else {
            String currentInput = context.arguments().getOr(inputDepth, null);
            assert (currentInput != null);
            if (!this.hasAutoCompletionPermission(context.source(), node)) {
                return;
            }
            if (node.isGreedyParam()) {
                this.tabCompleteNode(node, context, lastIndex, results);
                return;
            }
            if (!node.matchesInput(inputDepth, context, node.isOptional()) && node.isRequired()) {
                return;
            }
            for (ParameterNode parameterNode : node.getChildren()) {
                this.tabCompleteNode(parameterNode, context, inputDepth + node.getConsumedArguments(), results);
            }
        }
    }

    private void collectOverlappingSuggestions(ParameterNode<S, ?> origin, ParameterNode<S, ?> currentNode, SuggestionContext<S> context, List<String> results) {
        for (ParameterNode parameterNode : currentNode.getChildren()) {
            if (parameterNode.data.valueType().equals(origin.data.valueType()) || (!parameterNode.isCommand() || !parameterNode.data.asCommand().isIgnoringACPerms()) && !this.hasPermission(context.source(), parameterNode)) continue;
            SuggestionResolver<S> resolver = this.getResolverCached((CommandParameter<S>)parameterNode.data);
            List<String> suggestions = resolver.autoComplete(context, (CommandParameter<S>)parameterNode.data);
            if (suggestions != null && !suggestions.isEmpty()) {
                results.addAll(suggestions);
            }
            if (!parameterNode.isOptional()) continue;
            this.collectOverlappingSuggestions(origin, parameterNode, context, results);
        }
    }

    private boolean hasPermission(S source, ParameterNode<S, ?> node) {
        return this.permissionChecker.hasPermission(source, node.getPermission());
    }

    private boolean hasAutoCompletionPermission(S src, ParameterNode<S, ?> node) {
        if (node.isCommand() && node.getData().asCommand().isIgnoringACPerms()) {
            return true;
        }
        return this.hasPermission(src, node);
    }

    private SuggestionResolver<S> getResolverCached(CommandParameter<S> param) {
        return this.imperatConfig.getParameterSuggestionResolver(param);
    }

    private static boolean fastStartsWith(String str, String prefix) {
        int prefixLen = prefix.length();
        if (str.length() < prefixLen) {
            return false;
        }
        if (prefixLen <= 3) {
            for (int i = 0; i < prefixLen; ++i) {
                if (Character.toLowerCase(str.charAt(i)) == Character.toLowerCase(prefix.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return str.regionMatches(true, 0, prefix, 0, prefixLen);
    }

    @Override
    public Set<CommandUsage<S>> getClosestUsages(Context<S> context) {
        ArgumentInput queue = context.arguments();
        String firstArg = queue.getOr(0, null);
        CommandNode<S> startingNode = firstArg == null ? this.root : this.findStartingNode(context, this.root);
        return startingNode == null ? Set.of(this.rootCommand.getDefaultUsage()) : this.getClosestUsagesRecursively(new LinkedHashSet<CommandUsage<S>>(), startingNode, context);
    }

    private ParameterNode<S, ?> findStartingNode(Context<S> context, ParameterNode<S, ?> root) {
        for (ParameterNode parameterNode : root.getChildren()) {
            if (!parameterNode.matchesInput(parameterNode.getDepth(), context)) continue;
            return parameterNode;
        }
        return null;
    }

    private Set<CommandUsage<S>> getClosestUsagesRecursively(Set<CommandUsage<S>> currentUsages, ParameterNode<S, ?> node, Context<S> context) {
        if (node.isExecutable()) {
            CommandUsage<S> usage = node.getExecutableUsage();
            currentUsages.add(usage);
        }
        if (!node.isLast()) {
            LinkedList<ParameterNode<S, ?>> children = node.getChildren();
            ArgumentInput arguments = context.arguments();
            for (ParameterNode parameterNode : children) {
                String correspondingInput = arguments.getOr(parameterNode.getDepth(), null);
                if (correspondingInput == null) {
                    if (!parameterNode.isRequired()) continue;
                    this.addPermittedUsages(currentUsages, parameterNode, context);
                    continue;
                }
                if (!parameterNode.matchesInput(parameterNode.getDepth(), context)) continue;
                this.addPermittedUsages(currentUsages, parameterNode, context);
            }
        }
        return currentUsages;
    }

    private void addPermittedUsages(Set<CommandUsage<S>> currentUsages, ParameterNode<S, ?> child, Context<S> context) {
        Set<CommandUsage<S>> childUsages = this.getClosestUsagesRecursively(new LinkedHashSet<CommandUsage<S>>(), child, context);
        currentUsages.addAll(childUsages);
    }
}

