/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.annotations.ContextResolved;
import studio.mevera.imperat.command.tree.help.HelpCoordinator;
import studio.mevera.imperat.command.tree.help.HelpQuery;
import studio.mevera.imperat.command.tree.help.theme.HelpTheme;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

@ContextResolved
public final class CommandHelp<S extends Source> {
    @NotNull
    private final ExecutionContext<S> context;
    @NotNull
    private final HelpCoordinator<S> coordinator;

    private CommandHelp(@NotNull ExecutionContext<S> context) {
        this.context = context;
        this.coordinator = context.imperatConfig().getHelpCoordinator();
    }

    public static <S extends Source> CommandHelp<S> create(ExecutionContext<S> context) {
        return new CommandHelp<S>(context);
    }

    public <C> void display(HelpQuery<S> query, HelpTheme<S, C> theme) {
        this.coordinator.showHelp(this.context, query, theme);
    }

    @NotNull
    public ExecutionContext<S> getContext() {
        return this.context;
    }

    @NotNull
    public HelpCoordinator<S> getCoordinator() {
        return this.coordinator;
    }
}

