/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import studio.mevera.imperat.command.tree.help.HelpEntryList;
import studio.mevera.imperat.command.tree.help.HelpQuery;
import studio.mevera.imperat.command.tree.help.TreeHelpVisitor;
import studio.mevera.imperat.command.tree.help.renderers.HelpLayoutRenderer;
import studio.mevera.imperat.command.tree.help.renderers.StandardHelpRenderer;
import studio.mevera.imperat.command.tree.help.theme.HelpTheme;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

public class HelpCoordinator<S extends Source> {
    private final TreeHelpVisitor<S> provider;
    private final HelpLayoutRenderer<S, ?> renderer;

    private HelpCoordinator(TreeHelpVisitor<S> provider, HelpLayoutRenderer<S, ?> renderer) {
        this.provider = provider;
        this.renderer = renderer;
    }

    public static <S extends Source> HelpCoordinator<S> create(TreeHelpVisitor<S> provider, HelpLayoutRenderer<S, ?> renderer) {
        return new HelpCoordinator<S>(provider, renderer);
    }

    public static <S extends Source> HelpCoordinator<S> create() {
        return new HelpCoordinator(TreeHelpVisitor.defaultProvider(), new StandardHelpRenderer());
    }

    public <C> void showHelp(ExecutionContext<S> context, HelpQuery<S> query, HelpTheme<S, C> theme) {
        HelpEntryList<S> entries = this.provider.visit(context.command(), query);
        this.render(context, entries, theme);
    }

    private <C> void render(ExecutionContext<S> context, HelpEntryList<S> entries, HelpTheme<S, C> theme) {
        HelpLayoutRenderer<S, ?> typedRenderer = this.renderer;
        if (theme.getOptionValue(HelpTheme.Option.SHOW_HEADER).booleanValue()) {
            theme.getHeader(context).send(context.source());
        }
        typedRenderer.render(context, entries, theme);
        if (theme.getOptionValue(HelpTheme.Option.SHOW_FOOTER).booleanValue()) {
            theme.getFooter(context).send(context.source());
        }
    }
}

