/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.tree.ParameterNode;
import studio.mevera.imperat.context.Source;

public final class HelpEntry<S extends Source> {
    private final ParameterNode<S, ?> node;
    @NotNull
    private final CommandUsage<S> pathway;

    HelpEntry(ParameterNode<S, ?> node) {
        if (!node.isExecutable()) {
            throw new IllegalArgumentException("Node '" + node.format() + "' is not executable");
        }
        this.node = node;
        assert (node.getExecutableUsage() != null);
        this.pathway = node.getExecutableUsage();
    }

    @NotNull
    public CommandUsage<S> getPathway() {
        return this.pathway;
    }

    public ParameterNode<S, ?> getNode() {
        return this.node;
    }

    public boolean equals(Object object) {
        if (!(object instanceof HelpEntry)) {
            return false;
        }
        HelpEntry helpEntry = (HelpEntry)object;
        return Objects.equals(this.node, helpEntry.node);
    }

    public int hashCode() {
        return Objects.hashCode(this.node);
    }
}

