/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import studio.mevera.imperat.command.tree.help.HelpEntry;
import studio.mevera.imperat.context.Source;

public final class HelpEntryList<S extends Source>
implements Iterable<HelpEntry<S>> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float GROWTH_FACTOR = 1.2f;
    private HelpEntry<S>[] elements;
    private int size;
    private static final HelpEntryList<?> EMPTY_HELP_LIST = new HelpEntryList();

    public static <S extends Source> HelpEntryList<S> empty() {
        return EMPTY_HELP_LIST;
    }

    public HelpEntryList() {
        this.elements = new HelpEntry[16];
        this.size = 0;
    }

    public HelpEntryList(int initialCapacity) {
        if (initialCapacity <= 0) {
            throw new IllegalArgumentException("Initial capacity must be positive");
        }
        this.elements = new HelpEntry[initialCapacity];
        this.size = 0;
    }

    public boolean add(HelpEntry<S> entry) {
        if (entry == null) {
            throw new NullPointerException("Cannot add null entry");
        }
        if (this.containsInternal(entry)) {
            return false;
        }
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = entry;
        return true;
    }

    private boolean containsInternal(HelpEntry<S> entry) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].equals(entry)) continue;
            return true;
        }
        return false;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elements.length) {
            int newCapacity = (int)((float)this.elements.length * 1.2f);
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            HelpEntry[] newElements = new HelpEntry[newCapacity];
            System.arraycopy(this.elements, 0, newElements, 0, this.size);
            this.elements = newElements;
        }
    }

    public HelpEntry<S> get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.elements[index];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(HelpEntry<S> entry) {
        if (entry == null) {
            return false;
        }
        return this.containsInternal(entry);
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.elements[i] = null;
        }
        this.size = 0;
    }

    public int indexOf(HelpEntry<S> entry) {
        if (entry == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!this.elements[i].equals(entry)) continue;
            return i;
        }
        return -1;
    }

    public HelpEntry<S> remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        HelpEntry<S> removed = this.elements[index];
        int numToMove = this.size - index - 1;
        if (numToMove > 0) {
            System.arraycopy(this.elements, index + 1, this.elements, index, numToMove);
        }
        this.elements[--this.size] = null;
        return removed;
    }

    public boolean remove(HelpEntry<S> entry) {
        if (entry == null) {
            return false;
        }
        int index = this.indexOf(entry);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    public HelpEntry<S>[] toArray() {
        HelpEntry[] result = new HelpEntry[this.size];
        System.arraycopy(this.elements, 0, result, 0, this.size);
        return result;
    }

    public void trimToSize() {
        if (this.size < this.elements.length) {
            HelpEntry[] trimmed = new HelpEntry[this.size];
            System.arraycopy(this.elements, 0, trimmed, 0, this.size);
            this.elements = trimmed;
        }
    }

    public HelpEntryList<S> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        HelpEntryList<S> result = new HelpEntryList<S>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(this.elements[i]);
        }
        return result;
    }

    public int addAll(HelpEntryList<S> other) {
        if (other == null || other.isEmpty()) {
            return 0;
        }
        int added = 0;
        this.ensureCapacity(this.size + other.size);
        for (int i = 0; i < other.size; ++i) {
            if (!this.add(other.elements[i])) continue;
            ++added;
        }
        return added;
    }

    public int capacity() {
        return this.elements.length;
    }

    @Override
    public Iterator<HelpEntry<S>> iterator() {
        return new HelpEntryIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HelpEntryList)) {
            return false;
        }
        HelpEntryList that = (HelpEntryList)o;
        if (this.size != that.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.elements[i].equals(that.elements[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + (this.elements[i] == null ? 0 : this.elements[i].hashCode());
        }
        return result;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.elements[i]);
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public Set<HelpEntry<S>> toSet() {
        LinkedHashSet<HelpEntry<S>> set = new LinkedHashSet<HelpEntry<S>>(this.size);
        set.addAll(Arrays.asList(this.elements).subList(0, this.size));
        return set;
    }

    private class HelpEntryIterator
    implements Iterator<HelpEntry<S>> {
        private int cursor = 0;
        private int lastRet = -1;

        private HelpEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < HelpEntryList.this.size;
        }

        @Override
        public HelpEntry<S> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return HelpEntryList.this.elements[this.cursor++];
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            HelpEntryList.this.remove(this.lastRet);
            this.cursor = this.lastRet;
            this.lastRet = -1;
        }
    }
}

