/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.tree.ParameterNode;
import studio.mevera.imperat.command.tree.help.CommandHelp;
import studio.mevera.imperat.command.tree.help.HelpFilter;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.resolvers.PermissionChecker;

public final class HelpFilters {
    private HelpFilters() {
    }

    public static <S extends Source> HelpFilter<S> executable() {
        return ParameterNode::isExecutable;
    }

    public static <S extends Source> HelpFilter<S> commands() {
        return ParameterNode::isCommand;
    }

    public static <S extends Source> HelpFilter<S> arguments() {
        return node -> !node.isCommand();
    }

    public static <S extends Source> HelpFilter<S> depth(int minDepth, int maxDepth) {
        return node -> {
            int depth = node.getDepth();
            return depth >= minDepth && depth <= maxDepth;
        };
    }

    public static <S extends Source> HelpFilter<S> hasPermission(S source, PermissionChecker<S> checker) {
        return node -> {
            String permission = node.getPermission();
            return permission == null || checker.hasPermission(source, permission);
        };
    }

    public static <S extends Source> HelpFilter<S> hasPermission(S source, Context<S> context) {
        return HelpFilters.hasPermission(source, context.imperatConfig().getPermissionChecker());
    }

    public static <S extends Source> HelpFilter<S> hasPermission(S source, CommandHelp<S> help) {
        return HelpFilters.hasPermission(source, help.getContext());
    }

    public static <S extends Source> HelpFilter<S> withPermission(String permission) {
        return node -> permission.equals(node.getPermission());
    }

    public static <S extends Source> HelpFilter<S> noPermission() {
        return node -> node.getPermission() == null;
    }

    public static <S extends Source> HelpFilter<S> nameMatches(String pattern) {
        Pattern regex = Pattern.compile(pattern);
        return node -> regex.matcher(node.getData().name()).matches();
    }

    public static <S extends Source> HelpFilter<S> nameContains(String substring) {
        String lower = substring.toLowerCase();
        return node -> node.getData().name().toLowerCase().contains(lower);
    }

    public static <S extends Source> HelpFilter<S> optional() {
        return ParameterNode::isOptional;
    }

    public static <S extends Source> HelpFilter<S> required() {
        return ParameterNode::isRequired;
    }

    public static <S extends Source> HelpFilter<S> all() {
        return node -> true;
    }

    public static <S extends Source> HelpFilter<S> none() {
        return node -> false;
    }

    @SafeVarargs
    public static <S extends Source> HelpFilter<S> allOf(HelpFilter<S> ... filters) {
        return node -> {
            for (HelpFilter filter : filters) {
                if (filter.filter(node)) continue;
                return false;
            }
            return true;
        };
    }

    @SafeVarargs
    public static <S extends Source> HelpFilter<S> anyOf(HelpFilter<S> ... filters) {
        return node -> {
            for (HelpFilter filter : filters) {
                if (!filter.filter(node)) continue;
                return true;
            }
            return false;
        };
    }

    @NotNull
    public static <S extends Source> HelpFilter<S> childrenOnly() {
        return node -> node.getParent() != null;
    }
}

