/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help;

import java.util.LinkedList;
import java.util.Queue;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.tree.help.HelpFilter;
import studio.mevera.imperat.context.Source;

public final class HelpQuery<S extends Source> {
    private final int maxDepth;
    private final int limit;
    @NotNull
    private final Queue<HelpFilter<S>> filters;
    @NotNull
    private final Predicate<CommandUsage<S>> rootUsagePredicate;

    private HelpQuery(int maxDepth, int limit, @NotNull Queue<HelpFilter<S>> filters, @NotNull Predicate<CommandUsage<S>> rootUsagePredicate) {
        this.maxDepth = maxDepth;
        this.limit = limit;
        this.filters = filters;
        this.rootUsagePredicate = rootUsagePredicate;
    }

    public static <S extends Source> Builder<S> builder() {
        return new Builder();
    }

    public int getLimit() {
        return this.limit;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    @NotNull
    public Queue<HelpFilter<S>> getFilters() {
        return this.filters;
    }

    @NotNull
    public Predicate<CommandUsage<S>> getRootUsagePredicate() {
        return this.rootUsagePredicate;
    }

    public static class Builder<S extends Source> {
        private int maxDepth = 25;
        private int limit = 50;
        @NotNull
        private final Queue<HelpFilter<S>> filters = new LinkedList<HelpFilter<S>>();
        @NotNull
        private Predicate<CommandUsage<S>> rootUsagePredicate = u -> u.size() > 0;

        Builder() {
        }

        public Builder<S> maxDepth(int depth) {
            this.maxDepth = depth;
            return this;
        }

        public Builder<S> limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder<S> conditionalRootUsage(Predicate<CommandUsage<S>> rootUsagePredicate) {
            this.rootUsagePredicate = rootUsagePredicate;
            return this;
        }

        public Builder<S> filter(@NotNull HelpFilter<S> filter) {
            this.filters.add(filter);
            return this;
        }

        @NotNull
        public HelpQuery<S> build() {
            return new HelpQuery<S>(this.maxDepth, this.limit, this.filters, this.rootUsagePredicate);
        }
    }
}

