/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help.renderers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.tree.help.HelpEntry;
import studio.mevera.imperat.command.tree.help.HelpEntryList;
import studio.mevera.imperat.command.tree.help.renderers.HelpLayoutRenderer;
import studio.mevera.imperat.command.tree.help.theme.HelpComponent;
import studio.mevera.imperat.command.tree.help.theme.HelpTheme;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

public final class StandardHelpRenderer<S extends Source, C>
implements HelpLayoutRenderer<S, C> {
    @Override
    public void render(@NotNull ExecutionContext<S> context, @NotNull HelpEntryList<S> helpEntries, @NotNull HelpTheme<S, C> theme) {
        if (theme.getPreferredStyle() == HelpTheme.PresentationStyle.TREE) {
            this.renderTree(context, helpEntries, theme);
        } else {
            this.renderFlat(context, helpEntries, theme);
        }
    }

    private void renderFlat(@NotNull ExecutionContext<S> context, @NotNull HelpEntryList<S> helpEntries, @NotNull HelpTheme<S, C> theme) {
        Object source = context.source();
        for (HelpEntry<S> entry : helpEntries) {
            HelpComponent component = theme.getUsageFormatter().format(context.command(), entry.getPathway(), context, theme);
            component.send(source);
        }
    }

    private void renderTree(@NotNull ExecutionContext<S> context, @NotNull HelpEntryList<S> helpEntries, @NotNull HelpTheme<S, C> theme) {
        if (helpEntries.isEmpty()) {
            return;
        }
        List<HelpEntry<S>> sortedEntries = this.sortBySubcommandPath(helpEntries);
        HashSet<String> renderedPaths = new HashSet<String>();
        for (HelpEntry<S> entry : sortedEntries) {
            this.renderSubcommandHierarchy(context, entry, sortedEntries, theme, renderedPaths);
        }
    }

    private void renderSubcommandHierarchy(ExecutionContext<S> context, HelpEntry<S> entry, List<HelpEntry<S>> allEntries, HelpTheme<S, C> theme, Set<String> renderedPaths) {
        CommandUsage<S> usage = entry.getPathway();
        Object source = context.source();
        List<Integer> subcommandPositions = this.getSubcommandPositions(usage);
        for (int pos : subcommandPositions) {
            CommandParameter<S> parameter = usage.getParameter(pos);
            String pathUpToPos = this.buildSubcommandPath(usage, pos);
            if (renderedPaths.contains(pathUpToPos)) continue;
            renderedPaths.add(pathUpToPos);
            boolean isLastSubcommand = pos == subcommandPositions.get(subcommandPositions.size() - 1);
            boolean hasChildSubcommands = this.hasChildSubcommands(allEntries, usage, pos);
            HelpComponent prefix = this.buildPrefixForPosition(allEntries, entry, pos, theme);
            boolean isLastSibling = this.isLastSiblingAtPosition(allEntries, entry, pos);
            if (pos > 0) {
                HelpComponent<S, C> branch = theme.getTreeBranch(isLastSibling);
                prefix = prefix.append(branch);
            }
            HelpComponent line = prefix;
            if (isLastSubcommand && !hasChildSubcommands) {
                HelpComponent<S, C> formatted = theme.getUsageFormatter().format(context.command(), usage, context, theme);
                line = line.append(formatted);
            } else {
                assert (parameter != null);
                line = line.appendParameterFormat(parameter);
            }
            line.send(source);
        }
    }

    private List<Integer> getSubcommandPositions(CommandUsage<S> usage) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < usage.size(); ++i) {
            CommandParameter<S> parameter = usage.getParameter(i);
            assert (parameter != null);
            if (!parameter.isCommand()) continue;
            positions.add(parameter.position());
        }
        Collections.sort(positions);
        return positions;
    }

    private String buildSubcommandPath(CommandUsage<S> usage, int upToPosition) {
        StringBuilder path = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < usage.size(); ++i) {
            CommandParameter<S> parameter = usage.getParameter(i);
            assert (parameter != null);
            if (!parameter.isCommand() || parameter.position() > upToPosition) continue;
            if (!first) {
                path.append("/");
            }
            path.append(parameter.name());
            first = false;
        }
        return path.toString();
    }

    private boolean hasChildSubcommands(List<HelpEntry<S>> allEntries, CommandUsage<S> currentUsage, int position) {
        String currentPath = this.buildSubcommandPath(currentUsage, position);
        for (HelpEntry<S> otherEntry : allEntries) {
            CommandUsage<S> otherUsage = otherEntry.getPathway();
            for (int i = 0; i < otherUsage.size(); ++i) {
                String otherPath;
                CommandParameter<S> parameter = otherUsage.getParameter(i);
                assert (parameter != null);
                if (!parameter.isCommand() || parameter.position() <= position || !currentPath.equals(otherPath = this.buildSubcommandPath(otherUsage, position))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isLastSiblingAtPosition(List<HelpEntry<S>> allEntries, HelpEntry<S> currentEntry, int position) {
        CommandUsage<S> currentUsage = currentEntry.getPathway();
        CommandParameter<S> currentParameter = currentUsage.getParameter(position);
        if (position == 0) {
            assert (currentParameter != null);
            String currentSubcommand = currentParameter.name();
            for (HelpEntry<S> otherEntry : allEntries) {
                CommandUsage<S> otherUsage = otherEntry.getPathway();
                for (int i = 0; i < otherUsage.size(); ++i) {
                    String otherSubcommand;
                    CommandParameter<S> otherParameter = otherUsage.getParameter(i);
                    assert (otherParameter != null);
                    if (!otherParameter.isCommand() || otherParameter.position() != 0 || (otherSubcommand = otherParameter.name()).compareTo(currentSubcommand) <= 0) continue;
                    return false;
                }
            }
            return true;
        }
        String parentPath = this.buildSubcommandPath(currentUsage, position - 1);
        assert (currentParameter != null);
        String currentSubcommand = currentParameter.name();
        for (HelpEntry<S> otherEntry : allEntries) {
            CommandUsage<S> otherUsage = otherEntry.getPathway();
            for (int i = 0; i < otherUsage.size(); ++i) {
                String otherSubcommand;
                String otherParentPath;
                CommandParameter<S> otherParameter = otherUsage.getParameter(i);
                assert (otherParameter != null);
                if (!otherParameter.isCommand() || otherParameter.position() != position || !parentPath.equals(otherParentPath = this.buildSubcommandPath(otherUsage, position - 1)) || (otherSubcommand = otherParameter.name()).compareTo(currentSubcommand) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    private HelpComponent<S, C> buildPrefixForPosition(List<HelpEntry<S>> allEntries, HelpEntry<S> currentEntry, int targetPosition, HelpTheme<S, C> theme) {
        if (targetPosition <= 0) {
            return theme.createEmptyComponent();
        }
        HelpComponent<S, C> prefix = theme.createEmptyComponent();
        for (int pos = 0; pos < targetPosition; ++pos) {
            boolean hasMoreSiblings = !this.isLastSiblingAtPosition(allEntries, currentEntry, pos);
            HelpComponent<S, C> indent = theme.getTreeIndent(hasMoreSiblings);
            prefix = prefix.append(indent);
        }
        return prefix;
    }

    private List<HelpEntry<S>> sortBySubcommandPath(HelpEntryList<S> entries) {
        ArrayList<HelpEntry<S>> sorted = new ArrayList<HelpEntry<S>>();
        for (HelpEntry<S> entry : entries) {
            sorted.add(entry);
        }
        sorted.sort((a, b) -> {
            CommandUsage pathA = a.getPathway();
            CommandUsage pathB = b.getPathway();
            List<Integer> positionsA = this.getSubcommandPositions(pathA);
            List<Integer> positionsB = this.getSubcommandPositions(pathB);
            int minPositions = Math.min(positionsA.size(), positionsB.size());
            for (int i = 0; i < minPositions; ++i) {
                String commandB;
                int posA = positionsA.get(i);
                int posB = positionsB.get(i);
                String commandA = Objects.requireNonNull(pathA.getParameter(posA)).name();
                int cmp = commandA.compareTo(commandB = Objects.requireNonNull(pathB.getParameter(posB)).name());
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(positionsA.size(), positionsB.size());
        });
        return sorted;
    }
}

