/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help.theme;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.tree.help.theme.HelpComponent;
import studio.mevera.imperat.command.tree.help.theme.HelpTheme;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

public abstract class BaseHelpTheme<S extends Source, C>
implements HelpTheme<S, C> {
    @NotNull
    private final HelpTheme.PresentationStyle style;
    private final int indentMultiplier;
    private final Function<C, HelpComponent<S, C>> componentFactory;
    private final Map<HelpTheme.Option<?>, Object> optionValues = new HashMap();

    protected BaseHelpTheme(@NotNull HelpTheme.PresentationStyle style, int indentMultiplier, Function<C, HelpComponent<S, C>> componentFactory) {
        this.optionValues.put(HelpTheme.Option.SHOW_HEADER, true);
        this.optionValues.put(HelpTheme.Option.SHOW_FOOTER, true);
        this.style = style;
        this.indentMultiplier = indentMultiplier;
        this.componentFactory = componentFactory;
    }

    protected BaseHelpTheme(HelpTheme.PresentationStyle style, Function<C, HelpComponent<S, C>> componentFactory) {
        this(style, 1, componentFactory);
    }

    @Override
    @NotNull
    public HelpTheme.PresentationStyle getPreferredStyle() {
        return this.style;
    }

    @Override
    public int getIndentMultiplier() {
        return this.indentMultiplier;
    }

    @NotNull
    public abstract C createEmptyContent();

    @NotNull
    public abstract C getBranchContent();

    @NotNull
    public abstract C getLastBranchContent();

    @NotNull
    public abstract C getIndentContent();

    @NotNull
    public abstract C getEmptyIndentContent();

    @NotNull
    public abstract C getHeaderContent(ExecutionContext<S> var1);

    @NotNull
    public abstract C getFooterContent(ExecutionContext<S> var1);

    @Override
    public final HelpComponent<S, C> createEmptyComponent() {
        return this.componentFactory.apply(this.createEmptyContent());
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getBranch() {
        return this.componentFactory.apply(this.getBranchContent());
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getLastBranch() {
        return this.componentFactory.apply(this.getLastBranchContent());
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getIndent() {
        return this.componentFactory.apply(this.getIndentContent());
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getEmptyIndent() {
        return this.componentFactory.apply(this.getEmptyIndentContent());
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getHeader(ExecutionContext<S> context) {
        return this.componentFactory.apply(this.getHeaderContent(context));
    }

    @Override
    @NotNull
    public final HelpComponent<S, C> getFooter(ExecutionContext<S> context) {
        return this.componentFactory.apply(this.getFooterContent(context));
    }

    @Override
    public <T> T getOptionValue(@NotNull HelpTheme.Option<T> option) {
        return (T)this.optionValues.getOrDefault(option, option.defaultValue());
    }

    @Override
    public <T> void setOptionValue(@NotNull HelpTheme.Option<T> option, T value) {
        this.optionValues.put(option, value);
    }
}

