/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.command.tree.help.theme;

import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.tree.help.renderers.UsageFormatter;
import studio.mevera.imperat.command.tree.help.theme.HelpComponent;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

public interface HelpTheme<S extends Source, C> {
    public HelpComponent<S, C> createEmptyComponent();

    @NotNull
    public PresentationStyle getPreferredStyle();

    public int getIndentMultiplier();

    @NotNull
    public HelpComponent<S, C> getBranch();

    @NotNull
    public HelpComponent<S, C> getLastBranch();

    @NotNull
    public HelpComponent<S, C> getIndent();

    @NotNull
    public HelpComponent<S, C> getEmptyIndent();

    public <T> void setOptionValue(@NotNull Option<T> var1, T var2);

    @NotNull
    default public HelpComponent<S, C> getTreeBranch(boolean isLast) {
        return isLast ? this.getLastBranch() : this.getBranch();
    }

    @NotNull
    default public HelpComponent<S, C> getTreeIndent(boolean hasMore) {
        HelpComponent<S, C> base;
        HelpComponent<S, C> helpComponent = base = hasMore ? this.getIndent() : this.getEmptyIndent();
        if (this.getIndentMultiplier() > 1) {
            return base.repeat(this.getIndentMultiplier());
        }
        return base;
    }

    @NotNull
    public HelpComponent<S, C> getHeader(ExecutionContext<S> var1);

    @NotNull
    public HelpComponent<S, C> getFooter(ExecutionContext<S> var1);

    public <T> T getOptionValue(@NotNull Option<T> var1);

    @NotNull
    public UsageFormatter<S, C> getUsageFormatter();

    public static interface Option<T> {
        public static final Option<Boolean> SHOW_HEADER = new Option<Boolean>(){

            @Override
            @NotNull
            public String id() {
                return "show_header";
            }

            @Override
            @NotNull
            public Boolean defaultValue() {
                return false;
            }
        };
        public static final Option<Boolean> SHOW_FOOTER = new Option<Boolean>(){

            @Override
            @NotNull
            public String id() {
                return "show_footer";
            }

            @Override
            @NotNull
            public Boolean defaultValue() {
                return false;
            }
        };

        @NotNull
        public String id();

        @NotNull
        public T defaultValue();
    }

    public static enum PresentationStyle {
        TREE,
        FLAT;

    }
}

