/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context;

import java.util.Deque;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.ContextResolved;
import studio.mevera.imperat.context.ArgumentInputImpl;
import studio.mevera.imperat.util.StringUtils;

@ContextResolved
@ApiStatus.AvailableSince(value="1.0.0")
public interface ArgumentInput
extends Deque<String>,
List<String>,
Cloneable {
    public static ArgumentInput parse(String[] rawArguments) {
        return StringUtils.parseToQueue(String.join((CharSequence)" ", rawArguments), false);
    }

    public static ArgumentInput parse(String string) {
        return StringUtils.parseToQueue(string, false);
    }

    public static ArgumentInput parseAutoCompletion(String[] argumentsOnly, boolean extraLastSpace) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < argumentsOnly.length; ++i) {
            String arg = argumentsOnly[i];
            builder.append(arg);
            if (!extraLastSpace) {
                if (i == argumentsOnly.length - 1) continue;
                builder.append(" ");
                continue;
            }
            builder.append(" ");
        }
        return ArgumentInput.parseAutoCompletion(builder.toString(), extraLastSpace);
    }

    public static ArgumentInput parseAutoCompletion(String string, boolean extraLastSpace) {
        if (string.isEmpty()) {
            return StringUtils.parseToQueue("", true);
        }
        return StringUtils.parseToQueue(string, true, extraLastSpace);
    }

    public static ArgumentInput of(String originalLine) {
        return new ArgumentInputImpl(originalLine, new String[0]);
    }

    public static ArgumentInput empty() {
        return new ArgumentInputImpl();
    }

    public String getOriginalRaw();

    @Nullable
    default public String getOr(int index, @Nullable String def) {
        if (index < 0 || index >= this.size()) {
            return def;
        }
        return (String)this.get(index);
    }

    @NotNull
    public String join(String var1);

    @NotNull
    public String join(@NotNull String var1, int var2);

    @NotNull
    public ArgumentInput copy();
}

