/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.StringJoiner;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.context.ArgumentInput;

@ApiStatus.Internal
final class ArgumentInputImpl
extends LinkedList<String>
implements ArgumentInput {
    private final String originalRaw;

    ArgumentInputImpl(String originalRaw, @NotNull Collection<? extends String> input) {
        super(input);
        this.originalRaw = originalRaw;
    }

    ArgumentInputImpl(String originalRaw, String ... rawArgs) {
        this.originalRaw = originalRaw;
        Collections.addAll(this, rawArgs);
    }

    ArgumentInputImpl() {
        this.originalRaw = "";
    }

    @Override
    public String getOriginalRaw() {
        return this.originalRaw;
    }

    @Override
    @NotNull
    public String join(String delimiter) {
        return String.join((CharSequence)delimiter, this);
    }

    @Override
    @NotNull
    public String join(@NotNull String delimiter, int startIndex) {
        StringJoiner joiner = new StringJoiner(delimiter);
        for (int i = startIndex; i < this.size(); ++i) {
            joiner.add((CharSequence)this.get(i));
        }
        return joiner.toString();
    }

    @Override
    @NotNull
    public ArgumentInput copy() {
        return new ArgumentInputImpl(this.originalRaw, this);
    }
}

