/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.annotations.ContextResolved;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.Argument;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.exception.ImperatException;

@ContextResolved
@ApiStatus.AvailableSince(value="1.0.0")
public interface ExecutionContext<S extends Source>
extends Context<S> {
    @NotNull
    public CommandPathSearch<S> getPathwaySearch();

    public Optional<ExtractedInputFlag> getFlag(String var1);

    @Nullable
    public <T> T getFlagValue(String var1);

    @Nullable
    public <T> T getArgument(String var1);

    @NotNull
    default public <T> T getArgumentOr(String name, T value) {
        T argValue = this.getArgument(name);
        if (argValue != null) {
            return argValue;
        }
        return value;
    }

    default public String getRawArgument(int index) {
        if (index >= this.arguments().size() || index < 0) {
            return null;
        }
        return (String)this.arguments().get(index);
    }

    @NotNull
    public <R> R getResolvedSource(Type var1) throws ImperatException;

    @Nullable
    public <T> T getContextResolvedArgument(Class<T> var1) throws ImperatException;

    public Collection<? extends ExtractedInputFlag> getResolvedFlags();

    public <T> void resolveArgument(Command<S> var1, @Nullable String var2, int var3, CommandParameter<S> var4, @Nullable T var5) throws ImperatException;

    default public <T> void resolveArgument(CommandInputStream<S> stream, @Nullable T value) throws ImperatException {
        this.resolveArgument(this.getLastUsedCommand(), stream.currentRawIfPresent(), stream.currentRawPosition(), stream.currentParameterIfPresent(), value);
    }

    default public void resolveFlag(FlagData<S> flagDetected, String flagRaw, @Nullable String flagInputRaw, @Nullable Object flagInputValue) {
        this.resolveFlag(new ExtractedInputFlag(flagDetected, flagRaw, flagInputRaw, flagInputValue));
    }

    public void resolveFlag(ExtractedInputFlag var1);

    public Command<S> getLastUsedCommand();

    public CommandUsage<S> getDetectedUsage();

    public void resolve() throws ImperatException;

    @Nullable
    public Argument<S> getResolvedArgument(Command<S> var1, String var2);

    public List<Argument<S>> getResolvedArguments(Command<S> var1);

    @NotNull
    public Iterable<? extends Command<S>> getCommandsUsed();

    public Collection<? extends Argument<S>> getResolvedArguments();

    default public boolean hasResolvedFlag(CommandParameter<S> currentParameter) {
        if (!currentParameter.isFlag()) {
            return false;
        }
        return this.hasResolvedFlag(currentParameter.asFlagParameter().flagData());
    }

    public boolean hasResolvedFlag(FlagData<S> var1);

    public void debug();
}

