/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.Source;

public final class ExecutionResult<S extends Source> {
    @Nullable
    private Throwable error;
    private ExecutionContext<S> executionContext;
    private final Context<S> context;
    private CommandPathSearch<S> search;

    private ExecutionResult(@NotNull ExecutionContext<S> executionContext, Context<S> context, @NotNull CommandPathSearch<S> search) {
        this.executionContext = executionContext;
        this.context = context;
        this.search = search;
    }

    private ExecutionResult(@Nullable Throwable ex, Context<S> context) {
        this.error = ex;
        this.context = context;
    }

    public static <S extends Source> ExecutionResult<S> of(ExecutionContext<S> executionContext, CommandPathSearch<S> search, Context<S> context) {
        return new ExecutionResult<S>(executionContext, context, search);
    }

    public static <S extends Source> ExecutionResult<S> failure(@Nullable Throwable error, Context<S> context) {
        return new ExecutionResult<S>(error, context);
    }

    public static <S extends Source> ExecutionResult<S> failure(Context<S> context) {
        return ExecutionResult.failure(null, context);
    }

    public boolean hasFailed() {
        return this.executionContext == null || this.search == null;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public Context<S> getContext() {
        return this.context;
    }

    public CommandPathSearch<S> getSearch() {
        return this.search;
    }

    public ExecutionContext<S> getExecutionContext() {
        return this.executionContext;
    }
}

