/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context;

import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.SortedMap;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import studio.mevera.imperat.command.parameters.type.ParameterArray;
import studio.mevera.imperat.command.parameters.type.ParameterCollection;
import studio.mevera.imperat.command.parameters.type.ParameterCompletableFuture;
import studio.mevera.imperat.command.parameters.type.ParameterEnum;
import studio.mevera.imperat.command.parameters.type.ParameterMap;
import studio.mevera.imperat.command.parameters.type.ParameterOptional;
import studio.mevera.imperat.command.parameters.type.ParameterType;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.util.Registry;
import studio.mevera.imperat.util.TypeUtility;
import studio.mevera.imperat.util.TypeWrap;

@ApiStatus.Internal
public final class ParamTypeRegistry<S extends Source>
extends Registry<Type, Supplier<ParameterType>> {
    private final Registry<Type, Supplier<Collection<?>>> collectionInitializer = new Registry(LinkedHashMap::new);
    private final Registry<Type, Function<Integer, Object[]>> arrayInitializer;
    private final Registry<Type, Supplier<Map<?, ?>>> mapInitializer;

    private ParamTypeRegistry() {
        this.collectionInitializer.setData((Type)((Object)ArrayList.class), (Supplier<Collection<?>>)((Supplier<Collection>)ArrayList::new));
        this.collectionInitializer.setData((Type)((Object)LinkedList.class), (Supplier<Collection<?>>)((Supplier<Collection>)LinkedList::new));
        this.collectionInitializer.setData((Type)((Object)Vector.class), (Supplier<Collection<?>>)((Supplier<Collection>)Vector::new));
        this.collectionInitializer.setData((Type)((Object)Stack.class), (Supplier<Collection<?>>)((Supplier<Collection>)Stack::new));
        this.collectionInitializer.setData((Type)((Object)CopyOnWriteArrayList.class), (Supplier<Collection<?>>)((Supplier<Collection>)CopyOnWriteArrayList::new));
        this.collectionInitializer.setData((Type)((Object)HashSet.class), (Supplier<Collection<?>>)((Supplier<Collection>)HashSet::new));
        this.collectionInitializer.setData((Type)((Object)LinkedHashSet.class), (Supplier<Collection<?>>)((Supplier<Collection>)LinkedHashSet::new));
        this.collectionInitializer.setData((Type)((Object)TreeSet.class), (Supplier<Collection<?>>)((Supplier<Collection>)TreeSet::new));
        this.collectionInitializer.setData((Type)((Object)CopyOnWriteArraySet.class), (Supplier<Collection<?>>)((Supplier<Collection>)CopyOnWriteArraySet::new));
        this.collectionInitializer.setData((Type)((Object)ConcurrentSkipListSet.class), (Supplier<Collection<?>>)((Supplier<Collection>)ConcurrentSkipListSet::new));
        this.collectionInitializer.setData((Type)((Object)PriorityQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)PriorityQueue::new));
        this.collectionInitializer.setData((Type)((Object)ArrayDeque.class), (Supplier<Collection<?>>)((Supplier<Collection>)ArrayDeque::new));
        this.collectionInitializer.setData((Type)((Object)ConcurrentLinkedQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)ConcurrentLinkedQueue::new));
        this.collectionInitializer.setData((Type)((Object)ConcurrentLinkedDeque.class), (Supplier<Collection<?>>)((Supplier<Collection>)ConcurrentLinkedDeque::new));
        this.collectionInitializer.setData((Type)((Object)LinkedBlockingQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)LinkedBlockingQueue::new));
        this.collectionInitializer.setData((Type)((Object)PriorityBlockingQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)PriorityBlockingQueue::new));
        this.collectionInitializer.setData((Type)((Object)DelayQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)DelayQueue::new));
        this.collectionInitializer.setData((Type)((Object)SynchronousQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)SynchronousQueue::new));
        this.collectionInitializer.setData((Type)((Object)LinkedTransferQueue.class), (Supplier<Collection<?>>)((Supplier<Collection>)LinkedTransferQueue::new));
        this.arrayInitializer = new Registry(LinkedHashMap::new);
        this.arrayInitializer.setData((Type)((Object)Boolean.class), Boolean[]::new);
        this.arrayInitializer.setData((Type)((Object)Byte.class), Byte[]::new);
        this.arrayInitializer.setData((Type)((Object)Short.class), Short[]::new);
        this.arrayInitializer.setData((Type)((Object)Integer.class), Integer[]::new);
        this.arrayInitializer.setData((Type)((Object)Long.class), Long[]::new);
        this.arrayInitializer.setData((Type)((Object)Float.class), Float[]::new);
        this.arrayInitializer.setData((Type)((Object)Double.class), Double[]::new);
        this.arrayInitializer.setData((Type)((Object)Character.class), Character[]::new);
        this.arrayInitializer.setData((Type)((Object)String.class), String[]::new);
        this.mapInitializer = new Registry(LinkedHashMap::new);
        this.mapInitializer.setData((Type)((Object)HashMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)HashMap::new));
        this.mapInitializer.setData((Type)((Object)LinkedHashMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)LinkedHashMap::new));
        this.mapInitializer.setData((Type)((Object)TreeMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)TreeMap::new));
        this.mapInitializer.setData((Type)((Object)WeakHashMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)WeakHashMap::new));
        this.mapInitializer.setData((Type)((Object)IdentityHashMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)IdentityHashMap::new));
        this.mapInitializer.setData((Type)((Object)ConcurrentHashMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)ConcurrentHashMap::new));
        this.mapInitializer.setData((Type)((Object)ConcurrentSkipListMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)ConcurrentSkipListMap::new));
        this.mapInitializer.setData((Type)((Object)EnumMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)() -> {
            throw new UnsupportedOperationException("EnumMap requires an enum type parameter");
        }));
        this.mapInitializer.setData((Type)((Object)SortedMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)TreeMap::new));
        this.mapInitializer.setData((Type)((Object)NavigableMap.class), (Supplier<Map<?, ?>>)((Supplier<Map>)TreeMap::new));
        this.registerResolver((Type)((Object)Boolean.class), ParameterTypes::bool);
        this.registerResolver((Type)((Object)String.class), ParameterTypes::string);
        this.registerResolver((Type)((Object)UUID.class), ParameterTypes::uuid);
    }

    public static <S extends Source> ParamTypeRegistry<S> createDefault() {
        return new ParamTypeRegistry<S>();
    }

    public void registerResolver(Type type, Supplier<ParameterType> resolver) {
        this.setData(type, resolver);
    }

    <E, C extends Collection<E>> Supplier<C> initializeNewCollection(TypeWrap<?> fullType) {
        Class<?> collectionType = fullType.getRawType();
        Optional<Supplier<Collection<?>>> data = this.collectionInitializer.getData(collectionType);
        return data.map(collectionSupplier -> collectionSupplier).orElseGet(() -> this.collectionInitializer.search((ctype, supplier) -> TypeWrap.of(collectionType).isSupertypeOf((Type)ctype)).orElseThrow(() -> new IllegalArgumentException("Unknown collection-type detected '" + collectionType.getTypeName() + "'")));
    }

    Function<Integer, Object[]> initializeNewArray(TypeWrap<?> componentType) {
        Optional<Function<Integer, Object[]>> data = this.arrayInitializer.getData(componentType.getType());
        if (data.isEmpty()) {
            Function func = null;
            for (Type key : this.arrayInitializer.getKeys()) {
                if (componentType.isSupertypeOf(key) && (func = (Function)this.arrayInitializer.getData(key).orElse(null)) != null) break;
            }
            if (func == null) {
                throw new IllegalArgumentException("Unknown array-type detected '" + componentType.getType().getTypeName() + "'");
            }
            return func;
        }
        return data.get();
    }

    <K, V, M extends Map<K, V>> Supplier<M> initializeNewMap(TypeWrap<?> fullType) {
        Class<?> mapRawType = fullType.getRawType();
        Optional<Supplier<Map<?, ?>>> initializer = this.mapInitializer.getData(mapRawType);
        return initializer.map(mapSupplier -> mapSupplier).orElseGet(() -> this.mapInitializer.search((ctype, supplier) -> TypeWrap.of(mapRawType).isSupertypeOf((Type)ctype)).orElseThrow(() -> new IllegalArgumentException("Unknown map-type detected '" + mapRawType.getTypeName() + "'")));
    }

    private <E, C extends Collection<E>> ParameterCollection<S, E, C> getCollectionResolver(TypeWrap<?> type) {
        Type[] parameterizedTypes = type.getParameterizedTypes();
        if (parameterizedTypes == null) {
            throw new IllegalArgumentException("NULL PARAMETERIZED TYPES");
        }
        TypeWrap<?> componentType = TypeWrap.of(parameterizedTypes[0]);
        ParameterType componentResolver = this.getResolver(componentType.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + componentType.getType().getTypeName() + "'"));
        return new ParameterCollection(type, this.initializeNewCollection(type), componentResolver);
    }

    private <E> ParameterType<S, E[]> getArrayResolver(TypeWrap<?> type) {
        TypeWrap<?> componentType = type.getComponentType();
        if (componentType == null) {
            throw new IllegalArgumentException("NULL COMPONENT TYPE");
        }
        ParameterType componentResolver = this.getResolver(componentType.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + componentType.getType().getTypeName() + "'"));
        return new ParameterArray<S, E>(type, this.initializeNewArray(componentType), componentResolver){};
    }

    private <K, V, M extends Map<K, V>> ParameterMap<S, K, V, M> getMapResolver(TypeWrap<?> type) {
        Type[] parameterizedTypes = type.getParameterizedTypes();
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            throw new IllegalArgumentException("Raw types are not allowed as parameters !");
        }
        TypeWrap<?> keyType = TypeWrap.of(parameterizedTypes[0]);
        TypeWrap<?> valueType = TypeWrap.of(parameterizedTypes[0]);
        ParameterType keyResolver = this.getResolver(keyType.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + keyType.getType().getTypeName() + "'"));
        ParameterType valueResolver = this.getResolver(valueType.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + valueType.getType().getTypeName() + "'"));
        return new ParameterMap(type, this.initializeNewMap(type), keyResolver, valueResolver);
    }

    private <T> ParameterCompletableFuture<S, T> getFutureResolver(TypeWrap<?> type) {
        Type[] parameterizedTypes = type.getParameterizedTypes();
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            throw new IllegalArgumentException("Raw types are not allowed as parameters !");
        }
        TypeWrap<?> futureTypeInput = TypeWrap.of(parameterizedTypes[0]);
        ParameterType<S, T> futureTypeResolver = this.getResolver(futureTypeInput.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + futureTypeInput.getType().getTypeName() + "'"));
        return ParameterTypes.future(type, futureTypeResolver);
    }

    private <T> ParameterOptional<S, T> getOptionalResolver(TypeWrap<?> type) {
        Type[] parameterizedTypes = type.getParameterizedTypes();
        if (parameterizedTypes == null || parameterizedTypes.length == 0) {
            throw new IllegalArgumentException("Raw types are not allowed as parameters !");
        }
        TypeWrap<?> optionalType = TypeWrap.of(parameterizedTypes[0]);
        ParameterType<S, T> optionalTypeResolver = this.getResolver(optionalType.getType()).orElseThrow(() -> new IllegalArgumentException("Unknown component-type detected '" + optionalType.getType().getTypeName() + "'"));
        return ParameterTypes.optional(type, optionalTypeResolver);
    }

    public <C extends Collection<?>> void registerCollectionInitializer(Class<C> type, Supplier<C> initializerFunction) {
        this.collectionInitializer.setData(type, initializerFunction);
    }

    public <ArrayComponent> void registerArrayInitializer(Class<ArrayComponent> type, Function<Integer, Object[]> initializerFunction) {
        Object[] sample = initializerFunction.apply(0);
        if (!TypeUtility.matches(sample.getClass().getComponentType(), type)) {
            throw new IllegalArgumentException("Array initializer type '%s' does not match '%s'".formatted(type.getName(), sample.getClass().getComponentType()));
        }
        this.arrayInitializer.setData(type, initializerFunction);
    }

    public <M extends Map<?, ?>> void registerMapInitializer(Class<M> type, Supplier<M> initializerFunction) {
        this.mapInitializer.setData(type, initializerFunction);
    }

    public <T> Optional<ParameterType<S, T>> getResolver(Type type) {
        return Optional.ofNullable(this.getData(TypeUtility.primitiveToBoxed(type)).map(Supplier::get).orElseGet(() -> {
            TypeWrap<?> wrap = TypeWrap.of(type);
            if (wrap.isArray()) {
                return this.getArrayResolver(wrap);
            }
            if (wrap.isSubtypeOf((Type)((Object)Collection.class))) {
                return this.getCollectionResolver(wrap);
            }
            if (wrap.isSubtypeOf((Type)((Object)Map.class))) {
                return this.getMapResolver(wrap);
            }
            if (wrap.getRawType().equals(CompletableFuture.class)) {
                return this.getFutureResolver(wrap);
            }
            if (wrap.getRawType().equals(Optional.class)) {
                return this.getOptionalResolver(wrap);
            }
            if (TypeUtility.isNumericType(wrap)) {
                return ParameterTypes.numeric((Class)type);
            }
            if (TypeUtility.areRelatedTypes(type, Enum.class)) {
                return new ParameterEnum(TypeWrap.of(type));
            }
            for (Type registeredType : this.getKeys()) {
                if (!TypeUtility.areRelatedTypes(type, registeredType)) continue;
                return this.getData(registeredType).map(s -> (ParameterType)s.get()).orElse(null);
            }
            return null;
        }));
    }
}

