/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal;

import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStreamImpl;
import studio.mevera.imperat.context.internal.ShiftTarget;
import studio.mevera.imperat.context.internal.StreamPosition;

public interface CommandInputStream<S extends Source> {
    @NotNull
    public StreamPosition<S> position();

    public CommandInputStream<S> copy();

    @Nullable
    public CommandParameter<S> currentParameterIfPresent();

    @NotNull
    default public Optional<CommandParameter<S>> currentParameter() {
        return Optional.ofNullable(this.currentParameterIfPresent());
    }

    @Nullable
    public String currentRawIfPresent();

    @NotNull
    default public Optional<String> currentRaw() {
        return Optional.ofNullable(this.currentRawIfPresent());
    }

    @Nullable
    public Character currentLetterIfPresent();

    @NotNull
    default public Optional<Character> currentLetter() {
        return Optional.ofNullable(this.currentLetterIfPresent());
    }

    @Nullable
    public CommandParameter<S> peekParameterIfPresent();

    default public Optional<CommandParameter<S>> peekParameter() {
        return Optional.ofNullable(this.peekParameterIfPresent());
    }

    @Nullable
    public String peekRawIfPresent();

    default public Optional<String> peekRaw() {
        return Optional.ofNullable(this.peekRawIfPresent());
    }

    public Optional<Character> peekLetter();

    public Optional<CommandParameter<S>> prevParameter();

    public Optional<String> prevRaw();

    @Nullable
    public CommandParameter<S> nextParameter();

    @Nullable
    public String nextInput();

    public Optional<CommandParameter<S>> popParameter();

    public Optional<String> popRaw();

    public Optional<Character> popLetter();

    public boolean isCurrentParameterAvailable();

    public boolean isCurrentRawInputAvailable();

    public boolean isCurrentLetterAvailable();

    public boolean hasNextParameter();

    public boolean hasNextRaw();

    public boolean hasNextLetter();

    public boolean hasPreviousParameter();

    public boolean hasPreviousRaw();

    public boolean skip();

    default public boolean skipParameter() {
        StreamPosition<S> streamPosition = this.position();
        int prevParam = streamPosition.parameter;
        streamPosition.shiftRight(ShiftTarget.PARAMETER_ONLY);
        return streamPosition.parameter > prevParam;
    }

    default public boolean skipRaw() {
        StreamPosition<S> streamPosition = this.position();
        int prevRaw = streamPosition.raw;
        streamPosition.shiftRight(ShiftTarget.RAW_ONLY);
        return streamPosition.raw > prevRaw;
    }

    public boolean skipLetter();

    default public int currentParameterPosition() {
        return this.position().parameter;
    }

    default public int currentRawPosition() {
        return this.position().raw;
    }

    default public int parametersLength() {
        return this.getParametersList().size();
    }

    default public int rawsLength() {
        return this.getRawQueue().size();
    }

    @NotNull
    public List<CommandParameter<S>> getParametersList();

    @NotNull
    public ArgumentInput getRawQueue();

    default public boolean skipTill(char target) {
        boolean reached = false;
        while (this.hasNextLetter()) {
            Character current = this.currentLetterIfPresent();
            if (current != null && current.charValue() == target) {
                reached = true;
                break;
            }
            this.popLetter();
        }
        this.skipLetter();
        return reached;
    }

    default public String collectBeforeFirst(char c) {
        Character current;
        StringBuilder builder = new StringBuilder();
        while (this.hasNextLetter() && (current = this.currentLetterIfPresent()) != null && current.charValue() != c) {
            builder.append(current);
            this.skipLetter();
        }
        return builder.toString();
    }

    default public String readInput() {
        String current = this.currentRawIfPresent();
        if (current == null) {
            throw new NoSuchElementException("No raw input available");
        }
        return current;
    }

    default public void endInput() {
        this.position().raw = this.position().maxRawLength;
    }

    public void exemptParameter(CommandParameter<S> var1);

    public static <S extends Source> CommandInputStream<S> of(ArgumentInput queue, CommandUsage<S> usage) {
        return new CommandInputStreamImpl<S>(queue, usage);
    }

    public static <S extends Source> CommandInputStream<S> ofSingleString(@NotNull CommandParameter<S> parameter, @NotNull String str) {
        return new CommandInputStreamImpl<S>(ArgumentInput.of(str), List.of(parameter));
    }

    public static <S extends Source> CommandInputStream<S> subStream(@NotNull CommandInputStream<S> stream, @NotNull String input) {
        CommandParameter<S> param = stream.currentParameterIfPresent();
        if (param == null) {
            throw new NoSuchElementException("No current parameter available");
        }
        return CommandInputStream.ofSingleString(param, input);
    }
}

