/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal;

import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.context.ArgumentInput;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ShiftOperation;
import studio.mevera.imperat.context.internal.ShiftTarget;
import studio.mevera.imperat.context.internal.StreamPosition;

final class CommandInputStreamImpl<S extends Source>
implements CommandInputStream<S> {
    private final String inputLine;
    private final StreamPosition<S> streamPosition;
    private final ArgumentInput queue;
    private final List<CommandParameter<S>> parametersList;
    private final int[] rawStartPositions;
    private CommandParameter<S> cachedCurrentParameter = null;
    private String cachedCurrentRaw = null;
    private int lastParameterPosition = -1;
    private int lastRawPosition = -1;
    private boolean cacheValid = false;

    CommandInputStreamImpl(ArgumentInput queue, CommandUsage<S> parametersList) {
        this(queue, parametersList.getParameters());
    }

    CommandInputStreamImpl(ArgumentInput queue, List<CommandParameter<S>> parameters) {
        this(queue, parameters, new StreamPosition(parameters.size(), queue.size()), CommandInputStreamImpl.calculateRawStartPositions(queue, queue.getOriginalRaw()));
    }

    CommandInputStreamImpl(ArgumentInput queue, List<CommandParameter<S>> parameters, StreamPosition<S> streamPosition, int[] rawStartPositions) {
        this.queue = queue;
        this.inputLine = queue.getOriginalRaw();
        this.parametersList = parameters;
        this.streamPosition = streamPosition;
        this.rawStartPositions = rawStartPositions;
        this.updateCache();
    }

    private static int[] calculateRawStartPositions(ArgumentInput queue, String inputLine) {
        int[] positions = new int[queue.size()];
        int currentPos = 0;
        for (int i = 0; i < queue.size(); ++i) {
            String rawArg = (String)queue.get(i);
            while (currentPos < inputLine.length() && Character.isWhitespace(inputLine.charAt(currentPos))) {
                ++currentPos;
            }
            if (currentPos < inputLine.length() && CommandInputStreamImpl.isQuoteChar(inputLine.charAt(currentPos))) {
                positions[i] = currentPos + 1;
                currentPos = CommandInputStreamImpl.findClosingQuote(currentPos, inputLine) + 1;
                continue;
            }
            positions[i] = currentPos;
            currentPos += rawArg.length();
        }
        return positions;
    }

    private static boolean isQuoteChar(char c) {
        return c == '\"' || c == '\'';
    }

    private static int findClosingQuote(int openQuotePos, String inputLine) {
        char quoteChar = inputLine.charAt(openQuotePos);
        for (int i = openQuotePos + 1; i < inputLine.length(); ++i) {
            if (inputLine.charAt(i) != quoteChar) continue;
            return i;
        }
        return inputLine.length() - 1;
    }

    private void updateCache() {
        if (this.cacheValid && this.lastParameterPosition == this.streamPosition.parameter && this.lastRawPosition == this.streamPosition.raw) {
            return;
        }
        this.cachedCurrentParameter = this.streamPosition.parameter >= this.parametersList.size() ? null : this.parametersList.get(this.streamPosition.parameter);
        this.cachedCurrentRaw = this.streamPosition.raw >= this.queue.size() ? null : (String)this.queue.get(this.streamPosition.raw);
        this.lastParameterPosition = this.streamPosition.parameter;
        this.lastRawPosition = this.streamPosition.raw;
        this.cacheValid = true;
    }

    private void invalidateCache() {
        this.cacheValid = false;
    }

    private int getCurrentLetterPos() {
        if (this.streamPosition.raw >= this.rawStartPositions.length) {
            return this.inputLine.length();
        }
        return this.rawStartPositions[this.streamPosition.raw];
    }

    @Override
    @NotNull
    public StreamPosition<S> position() {
        return this.streamPosition;
    }

    @Override
    public CommandParameter<S> currentParameterIfPresent() {
        this.updateCache();
        return this.cachedCurrentParameter;
    }

    @Override
    public String currentRawIfPresent() {
        this.updateCache();
        return this.cachedCurrentRaw;
    }

    @Override
    public CommandParameter<S> peekParameterIfPresent() {
        int nextIndex = this.streamPosition.parameter + 1;
        if (nextIndex >= this.parametersList.size()) {
            return null;
        }
        return this.parametersList.get(nextIndex);
    }

    @Override
    public String peekRawIfPresent() {
        int nextIndex = this.streamPosition.raw + 1;
        return this.queue.getOr(nextIndex, null);
    }

    @Override
    public Character currentLetterIfPresent() {
        int letterPos = this.getCurrentLetterPos();
        if (letterPos >= this.inputLine.length()) {
            return null;
        }
        return Character.valueOf(this.inputLine.charAt(letterPos));
    }

    @Override
    @Nullable
    public String nextInput() {
        return this.popRaw().orElse(null);
    }

    @Override
    @Nullable
    public CommandParameter<S> nextParameter() {
        return this.popParameter().orElse(null);
    }

    @Override
    public Optional<CommandParameter<S>> popParameter() {
        this.streamPosition.shift(ShiftTarget.PARAMETER_ONLY, ShiftOperation.RIGHT);
        this.invalidateCache();
        CommandParameter<S> current = this.currentParameterIfPresent();
        return Optional.ofNullable(current);
    }

    @Override
    public Optional<CommandParameter<S>> prevParameter() {
        if (this.streamPosition.parameter <= 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.parametersList.get(this.streamPosition.parameter - 1));
    }

    @Override
    public Optional<Character> peekLetter() {
        int letterPos = this.getCurrentLetterPos();
        int nextLetterPos = letterPos + 1;
        if (nextLetterPos >= this.inputLine.length()) {
            return Optional.empty();
        }
        return Optional.of(Character.valueOf(this.inputLine.charAt(nextLetterPos)));
    }

    @Override
    public Optional<Character> popLetter() {
        int letterPos = this.getCurrentLetterPos();
        if (letterPos >= this.inputLine.length()) {
            return Optional.empty();
        }
        if (this.streamPosition.raw < this.rawStartPositions.length) {
            int n = this.streamPosition.raw;
            this.rawStartPositions[n] = this.rawStartPositions[n] + 1;
        }
        return Optional.of(Character.valueOf(this.inputLine.charAt(letterPos)));
    }

    @Override
    public Optional<String> popRaw() {
        this.streamPosition.shift(ShiftTarget.RAW_ONLY, ShiftOperation.RIGHT);
        this.invalidateCache();
        String current = this.currentRawIfPresent();
        return Optional.ofNullable(current);
    }

    @Override
    public Optional<String> prevRaw() {
        int prev = this.streamPosition.raw - 1;
        return Optional.ofNullable(this.queue.getOr(prev, null));
    }

    @Override
    public boolean isCurrentLetterAvailable() {
        return this.getCurrentLetterPos() < this.inputLine.length();
    }

    @Override
    public boolean hasNextLetter() {
        return this.getCurrentLetterPos() + 1 < this.inputLine.length();
    }

    @Override
    public boolean isCurrentRawInputAvailable() {
        return this.streamPosition.raw < this.rawsLength();
    }

    @Override
    public boolean hasPreviousRaw() {
        return this.streamPosition.raw > 0;
    }

    @Override
    public boolean hasNextRaw() {
        return this.streamPosition.raw + 1 < this.rawsLength();
    }

    @Override
    public boolean isCurrentParameterAvailable() {
        return this.streamPosition.parameter < this.parametersLength();
    }

    @Override
    public boolean hasPreviousParameter() {
        return this.streamPosition.parameter > 0;
    }

    @Override
    public boolean hasNextParameter() {
        return this.streamPosition.parameter + 1 < this.parametersLength();
    }

    @Override
    @NotNull
    public ArgumentInput getRawQueue() {
        return this.queue;
    }

    @Override
    @NotNull
    public List<CommandParameter<S>> getParametersList() {
        return this.parametersList;
    }

    @Override
    public boolean skip() {
        StreamPosition<S> streamPosition = this.position();
        int prevRaw = streamPosition.raw;
        streamPosition.shift(ShiftTarget.ALL, ShiftOperation.RIGHT);
        this.invalidateCache();
        return streamPosition.raw > prevRaw;
    }

    @Override
    public boolean skipLetter() {
        return this.popLetter().isPresent();
    }

    @Override
    public CommandInputStream<S> copy() {
        return new CommandInputStreamImpl<S>(this.queue.copy(), List.copyOf(this.parametersList), this.streamPosition.copy(), (int[])this.rawStartPositions.clone());
    }

    @Override
    public void exemptParameter(CommandParameter<S> matchingFlagParameter) {
        this.parametersList.remove(matchingFlagParameter);
    }
}

