/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.Command;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.NumericParameter;
import studio.mevera.imperat.command.parameters.NumericRange;
import studio.mevera.imperat.command.tree.CommandNode;
import studio.mevera.imperat.command.tree.CommandPathSearch;
import studio.mevera.imperat.context.Context;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.Argument;
import studio.mevera.imperat.context.internal.ContextImpl;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.context.internal.sur.ParameterValueAssigner;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.NumberOutOfRangeException;
import studio.mevera.imperat.resolvers.ContextResolver;
import studio.mevera.imperat.resolvers.SourceResolver;
import studio.mevera.imperat.util.ImperatDebugger;
import studio.mevera.imperat.util.Registry;
import studio.mevera.imperat.util.TypeUtility;

@ApiStatus.Internal
final class ExecutionContextImpl<S extends Source>
extends ContextImpl<S>
implements ExecutionContext<S> {
    private final CommandUsage<S> usage;
    private final Registry<String, ExtractedInputFlag> flagRegistry = new Registry();
    private final Registry<Command<S>, Registry<String, Argument<S>>> resolvedArgumentsPerCommand = new Registry(LinkedHashMap::new);
    private final Registry<String, Argument<S>> allResolvedArgs = new Registry(LinkedHashMap::new);
    private final Command<S> lastCommand;
    private final CommandPathSearch<S> pathSearch;

    ExecutionContextImpl(Context<S> context, CommandPathSearch<S> pathSearch) {
        super(context.imperat(), context.command(), context.source(), context.label(), context.arguments());
        this.pathSearch = pathSearch;
        CommandNode<S> lastCmdNode = pathSearch.getLastCommandNode();
        this.lastCommand = (Command)lastCmdNode.getData();
        this.usage = pathSearch.getFoundUsage();
    }

    @Override
    @Nullable
    public Argument<S> getResolvedArgument(Command<S> command, String name) {
        return this.resolvedArgumentsPerCommand.getData(command).flatMap(resolvedArgs -> resolvedArgs.getData(name)).orElse(null);
    }

    @Override
    public List<Argument<S>> getResolvedArguments(Command<S> command) {
        return this.resolvedArgumentsPerCommand.getData(command).map(argMap -> new ArrayList(argMap.getAll())).orElse(Collections.emptyList());
    }

    @Override
    @NotNull
    public Iterable<? extends Command<S>> getCommandsUsed() {
        return this.resolvedArgumentsPerCommand.getKeys();
    }

    @Override
    public Collection<? extends Argument<S>> getResolvedArguments() {
        return this.allResolvedArgs.getAll();
    }

    @Override
    @Nullable
    public <T> T getArgument(String name) {
        return this.allResolvedArgs.getData(name).map(Argument::value).orElse(null);
    }

    @Override
    @NotNull
    public <R> R getResolvedSource(Type type) throws ImperatException {
        if (!this.imperatConfig.hasSourceResolver(type)) {
            throw new IllegalArgumentException("Found no SourceResolver for valueType `" + type.getTypeName() + "`");
        }
        SourceResolver sourceResolver = this.imperatConfig.getSourceResolver(type);
        assert (sourceResolver != null);
        return sourceResolver.resolve(this.source(), this);
    }

    @Override
    @Nullable
    public <T> T getContextResolvedArgument(Class<T> type) throws ImperatException {
        ContextResolver resolver = this.imperatConfig.getContextResolver(type);
        return resolver == null ? null : (T)resolver.resolve(this, null);
    }

    @Override
    public Collection<? extends ExtractedInputFlag> getResolvedFlags() {
        return this.flagRegistry.getAll();
    }

    @Override
    @NotNull
    public CommandPathSearch<S> getPathwaySearch() {
        return this.pathSearch;
    }

    @Override
    public Optional<ExtractedInputFlag> getFlag(String flagName) {
        return this.flagRegistry.getData(flagName);
    }

    @Override
    @Nullable
    public <T> T getFlagValue(String flagName) {
        return this.getFlag(flagName).map(ExtractedInputFlag::value).orElse(null);
    }

    @Override
    public void resolve() throws ImperatException {
        ParameterValueAssigner<S> resolver = ParameterValueAssigner.create(this, this.usage);
        resolver.resolve();
    }

    @Override
    public <T> void resolveArgument(Command<S> command, @Nullable String raw, int index, CommandParameter<S> parameter, @Nullable T value) throws ImperatException {
        NumericParameter numericParameter;
        if (value != null && TypeUtility.isNumericType(value.getClass()) && parameter instanceof NumericParameter && (numericParameter = (NumericParameter)parameter).hasRange() && !numericParameter.matchesRange((Number)value)) {
            NumericRange range = numericParameter.getRange();
            throw new NumberOutOfRangeException(raw, numericParameter, (Number)value, range, this);
        }
        Argument argument = new Argument(raw, parameter, index, value);
        this.resolvedArgumentsPerCommand.update(command, existingResolvedArgs -> {
            if (existingResolvedArgs != null) {
                return existingResolvedArgs.setData(parameter.name(), argument);
            }
            return new Registry<String, Argument>(parameter.name(), argument, LinkedHashMap::new);
        });
        this.allResolvedArgs.setData(parameter.name(), argument);
    }

    @Override
    public void resolveFlag(ExtractedInputFlag flag) {
        this.flagRegistry.setData(flag.flag().name(), flag);
    }

    @Override
    @NotNull
    public Command<S> getLastUsedCommand() {
        return this.lastCommand;
    }

    @Override
    public CommandUsage<S> getDetectedUsage() {
        return this.usage;
    }

    @Override
    public boolean hasResolvedFlag(FlagData<S> flagData) {
        return this.flagRegistry.getData(flagData.name()).isPresent();
    }

    @Override
    public void debug() {
        if (this.allResolvedArgs.size() == 0) {
            ImperatDebugger.debug("No arguments were resolved!", new Object[0]);
            return;
        }
        for (Argument<S> arg : this.allResolvedArgs.getAll()) {
            ImperatDebugger.debug("Argument '%s' at index #%s with input='%s' with value='%s'", arg.parameter().format(), arg.index(), arg.raw(), arg.value());
        }
    }
}

