/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal;

import java.util.function.IntUnaryOperator;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.ShiftOperation;
import studio.mevera.imperat.context.internal.ShiftTarget;

public final class StreamPosition<S extends Source> {
    int maxParamLength;
    int maxRawLength;
    int parameter;
    int raw;

    StreamPosition(int maxParamLength, int maxRawLength, int parameter, int raw) {
        this.maxParamLength = maxParamLength;
        this.maxRawLength = maxRawLength;
        this.parameter = parameter;
        this.raw = raw;
    }

    StreamPosition(int maxParamLength, int maxRawLength) {
        this(maxParamLength, maxRawLength, 0, 0);
    }

    public int getRaw() {
        return this.raw;
    }

    public int getParameter() {
        return this.parameter;
    }

    void shift(ShiftTarget shift, IntUnaryOperator operator) {
        switch (shift) {
            case RAW_ONLY: {
                this.raw = operator.applyAsInt(this.raw);
                break;
            }
            case PARAMETER_ONLY: {
                this.parameter = operator.applyAsInt(this.parameter);
                break;
            }
            default: {
                this.raw = operator.applyAsInt(this.raw);
                this.parameter = operator.applyAsInt(this.parameter);
            }
        }
    }

    void shift(ShiftTarget target, ShiftOperation operation) {
        this.shift(target, operation.operator);
    }

    void shiftRight(ShiftTarget target) {
        this.shift(target, ShiftOperation.RIGHT);
    }

    void shiftLeft(ShiftTarget target) {
        this.shift(target, ShiftOperation.LEFT);
    }

    boolean canContinue(ShiftTarget target) {
        return target.canContinue(this);
    }

    boolean isLast(ShiftTarget shiftTarget, int maxParams, int maxRaws) {
        if (shiftTarget == ShiftTarget.PARAMETER_ONLY) {
            return this.parameter == maxParams - 1;
        }
        if (shiftTarget == ShiftTarget.RAW_ONLY) {
            return this.raw == maxRaws - 1;
        }
        return this.parameter == maxParams - 1 && this.raw == maxRaws - 1;
    }

    public boolean isLast(ShiftTarget shiftTarget) {
        return this.isLast(shiftTarget, this.maxParamLength, this.maxRawLength);
    }

    int maxRaws() {
        return this.maxRawLength;
    }

    int maxParameters() {
        return this.maxParamLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamPosition)) {
            return false;
        }
        StreamPosition other = (StreamPosition)o;
        if (this.parameter != other.parameter) {
            return false;
        }
        return this.raw == other.raw;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.parameter;
        result = result * 59 + this.raw;
        return result;
    }

    public StreamPosition<S> copy() {
        return new StreamPosition<S>(this.maxParamLength, this.maxRawLength, this.parameter, this.raw);
    }
}

