/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal.sur.handlers;

import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import studio.mevera.imperat.command.CommandUsage;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.FlagParameter;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.context.internal.sur.HandleResult;
import studio.mevera.imperat.context.internal.sur.handlers.ParameterHandler;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.exception.MissingFlagInputException;
import studio.mevera.imperat.exception.ShortHandFlagException;
import studio.mevera.imperat.util.Patterns;
import studio.mevera.imperat.util.TypeUtility;

public final class FlagInputHandler<S extends Source>
implements ParameterHandler<S> {
    @Override
    @NotNull
    public HandleResult handle(ExecutionContext<S> context, CommandInputStream<S> stream) {
        CommandParameter<S> currentParameter = stream.currentParameterIfPresent();
        String currentRaw = stream.currentRawIfPresent();
        if (currentParameter == null || currentRaw == null || !currentParameter.isFlag() || !Patterns.isInputFlag(currentRaw)) {
            return HandleResult.NEXT_HANDLER;
        }
        try {
            String inputRaw;
            CommandUsage<S> usage = context.getDetectedUsage();
            Set<FlagData<S>> extracted = usage.getFlagExtractor().extract(Patterns.withoutFlagSign(currentRaw), context);
            long numberOfSwitches = extracted.stream().filter(FlagData::isSwitch).count();
            long numberOfTrueFlags = (long)extracted.size() - numberOfSwitches;
            if ((long)extracted.size() != numberOfSwitches && (long)extracted.size() != numberOfTrueFlags) {
                return HandleResult.failure(new ShortHandFlagException("Unsupported use of a mixture of switches and true flags!", context));
            }
            if ((long)extracted.size() == numberOfTrueFlags && !TypeUtility.areTrueFlagsOfSameInputTpe(extracted)) {
                return HandleResult.failure(new ShortHandFlagException("You cannot use compressed true-flags, while they are not of same input type", context));
            }
            boolean areAllSwitches = (long)extracted.size() == numberOfSwitches;
            boolean areAllTrueFlags = (long)extracted.size() == numberOfTrueFlags;
            String string = inputRaw = areAllSwitches ? currentRaw : stream.peekRawIfPresent();
            if (inputRaw == null) {
                throw new MissingFlagInputException(currentParameter.asFlagParameter(), currentRaw, context);
            }
            if (extracted.size() == 1 && extracted.contains(currentParameter.asFlagParameter().flagData())) {
                context.resolveFlag((ExtractedInputFlag)ParameterTypes.flag(currentParameter.asFlagParameter().flagData()).resolve((ExecutionContext)context, (CommandInputStream)stream, currentRaw));
                stream.skip();
                return HandleResult.NEXT_ITERATION;
            }
            if (extracted.size() == 1) {
                this.resolveFlagDefaultValue(stream, currentParameter.asFlagParameter(), context);
                stream.skipParameter();
                return HandleResult.NEXT_ITERATION;
            }
            for (FlagData<S> extractedFlagData : extracted) {
                CommandParameter<S> matchingParam = this.getMatchingFlagParam(usage, stream, currentParameter.position() + 1, extractedFlagData);
                if (matchingParam == null) continue;
                context.resolveFlag(new ExtractedInputFlag(extractedFlagData, currentRaw, inputRaw, extractedFlagData.isSwitch() ? Boolean.valueOf(true) : Objects.requireNonNull(extractedFlagData.inputType()).resolve(context, stream, inputRaw)));
                stream.exemptParameter(matchingParam);
            }
            stream.skip();
            return HandleResult.NEXT_ITERATION;
        }
        catch (ImperatException e) {
            return HandleResult.failure(e);
        }
    }

    @Nullable
    private CommandParameter<S> getMatchingFlagParam(CommandUsage<S> usage, CommandInputStream<S> inputStream, int start, FlagData<S> extractedFlagData) {
        CommandParameter<S> param;
        for (int i = start; i < inputStream.parametersLength() && (param = usage.getParameter(i)) != null; ++i) {
            if (!param.isFlag() || !param.asFlagParameter().flagData().equals(extractedFlagData)) continue;
            return param;
        }
        return null;
    }

    private void resolveFlagDefaultValue(CommandInputStream<S> stream, FlagParameter<S> flagParameter, ExecutionContext<S> context) throws ImperatException {
        FlagData<S> flagDataFromRaw = flagParameter.flagData();
        if (flagDataFromRaw.isSwitch()) {
            context.resolveFlag(new ExtractedInputFlag(flagDataFromRaw, null, "false", false));
            return;
        }
        String defValue = flagParameter.getDefaultValueSupplier().supply(context, flagParameter);
        if (defValue != null) {
            Object flagValueResolved = flagParameter.getDefaultValueSupplier().isEmpty() ? null : Objects.requireNonNull(flagDataFromRaw.inputType()).resolve(context, CommandInputStream.subStream(stream, defValue), defValue);
            context.resolveFlag(new ExtractedInputFlag(flagDataFromRaw, null, defValue, flagValueResolved));
        }
    }
}

