/*
 * Decompiled with CFR 0.152.
 */
package studio.mevera.imperat.context.internal.sur.handlers;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import studio.mevera.imperat.command.parameters.CommandParameter;
import studio.mevera.imperat.command.parameters.type.ParameterTypes;
import studio.mevera.imperat.context.ExecutionContext;
import studio.mevera.imperat.context.FlagData;
import studio.mevera.imperat.context.Source;
import studio.mevera.imperat.context.internal.CommandInputStream;
import studio.mevera.imperat.context.internal.ExtractedInputFlag;
import studio.mevera.imperat.context.internal.sur.HandleResult;
import studio.mevera.imperat.context.internal.sur.handlers.ParameterHandler;
import studio.mevera.imperat.exception.ImperatException;
import studio.mevera.imperat.util.Patterns;

public final class FreeFlagHandler<S extends Source>
implements ParameterHandler<S> {
    @Override
    @NotNull
    public HandleResult handle(ExecutionContext<S> context, CommandInputStream<S> stream) {
        String currentRaw;
        CommandParameter<S> lastParam = context.getDetectedUsage().getParameter(context.getDetectedUsage().size() - 1);
        while (!((currentRaw = stream.currentRawIfPresent()) == null || lastParam != null && lastParam.isGreedy())) {
            Optional freeFlagData = context.getLastUsedCommand().getFlagFromRaw(currentRaw);
            if (Patterns.isInputFlag(currentRaw) && freeFlagData.isPresent()) {
                try {
                    FlagData freeFlag = freeFlagData.get();
                    ExtractedInputFlag value = ParameterTypes.flag(freeFlag).resolveFreeFlag(context, stream, freeFlag);
                    context.resolveFlag(value);
                }
                catch (ImperatException e) {
                    return HandleResult.failure(e);
                }
            }
            stream.skipRaw();
        }
        return HandleResult.TERMINATE;
    }
}

